// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using System;
using System.ComponentModel;

namespace Azure.Provisioning.EventHubs;

/// <summary>
/// Built-in EventHubs roles that you can assign to users, groups, service
/// principals, and managed identities.
/// </summary>
/// <param name="value">The ID value of the role.</param>
public readonly struct EventHubsBuiltInRole(string value) : IEquatable<EventHubsBuiltInRole>
{
    private readonly string _value = value ?? throw new ArgumentNullException(nameof(value));

    /// <summary>
    /// Allows for full access to Azure Event Hubs resources.
    /// </summary>
    public static EventHubsBuiltInRole AzureEventHubsDataOwner { get; } = new(AzureEventHubsDataOwnerValue);
    internal const string AzureEventHubsDataOwnerValue = "f526a384-b230-433a-b45c-95f59c4a2dec";

    /// <summary>
    /// Allows receive access to Azure Event Hubs resources.
    /// </summary>
    public static EventHubsBuiltInRole AzureEventHubsDataReceiver { get; } = new(AzureEventHubsDataReceiverValue);
    internal const string AzureEventHubsDataReceiverValue = "a638d3c7-ab3a-418d-83e6-5f17a39d4fde";

    /// <summary>
    /// Allows send access to Azure Event Hubs resources.
    /// </summary>
    public static EventHubsBuiltInRole AzureEventHubsDataSender { get; } = new(AzureEventHubsDataSenderValue);
    internal const string AzureEventHubsDataSenderValue = "2b629674-e913-4c01-ae53-ef4638d8f975";

    /// <summary>
    /// Read, write, and delete Schema Registry groups and schemas.
    /// </summary>
    public static EventHubsBuiltInRole SchemaRegistryContributor { get; } = new(SchemaRegistryContributorValue);
    internal const string SchemaRegistryContributorValue = "5dffeca3-4936-4216-b2bc-10343a5abb25";

    /// <summary>
    /// Read and list Schema Registry groups and schemas.
    /// </summary>
    public static EventHubsBuiltInRole SchemaRegistryReader { get; } = new(SchemaRegistryReaderValue);
    internal const string SchemaRegistryReaderValue = "2c56ea50-c6b3-40a6-83c0-9d98858bc7d2";

    /// <summary>
    /// Try to get the name of a built-in EventHubs role from its ID value.
    /// </summary>
    /// <param name="value">The role value.</param>
    /// <returns>
    /// The name of the built-in EventHubs role if known, otherwise the ID will be returned.
    /// </returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public static string GetBuiltInRoleName(EventHubsBuiltInRole value) =>
        value._value switch
        {
            AzureEventHubsDataOwnerValue => nameof(AzureEventHubsDataOwner),
            AzureEventHubsDataReceiverValue => nameof(AzureEventHubsDataReceiver),
            AzureEventHubsDataSenderValue => nameof(AzureEventHubsDataSender),
            SchemaRegistryContributorValue => nameof(SchemaRegistryContributor),
            SchemaRegistryReaderValue => nameof(SchemaRegistryReader),
            _ => value._value
        };

    /// <summary>
    /// Determines if two EventHubsBuiltInRole values are the same.
    /// </summary>
    /// <param name="left">The first EventHubsBuiltInRole to compare.</param>
    /// <param name="right">The second EventHubsBuiltInRole to compare.</param>
    /// <returns>True if <paramref name="left"/> and <paramref name="right"/> are the same; otherwise, false.</returns>
    public static bool operator ==(EventHubsBuiltInRole left, EventHubsBuiltInRole right) => left.Equals(right);

    /// <summary>
    /// Determines if two EventHubsBuiltInRole values are different.
    /// </summary>
    /// <param name="left">The first EventHubsBuiltInRole to compare.</param>
    /// <param name="right">The second EventHubsBuiltInRole to compare.</param>
    /// <returns>True if <paramref name="left"/> and <paramref name="right"/> are different; otherwise, false.</returns>
    public static bool operator !=(EventHubsBuiltInRole left, EventHubsBuiltInRole right) => !left.Equals(right);

    /// <summary>
    /// Converts a string to a EventHubsBuiltInRole.
    /// </summary>
    /// <param name="value">The string value to convert.</param>
    public static implicit operator EventHubsBuiltInRole(string value) => new(value);

    /// <inheritdoc/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override bool Equals(object? obj) => obj is EventHubsBuiltInRole other && Equals(other);

    /// <inheritdoc/>
    public bool Equals(EventHubsBuiltInRole other) => string.Equals(_value, other._value, StringComparison.Ordinal);

    /// <inheritdoc/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override int GetHashCode() => _value?.GetHashCode() ?? 0;

    /// <inheritdoc/>
    public override string ToString() => _value;
}
