// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.EventHubs;

/// <summary>
/// EventHubsApplicationGroup.
/// </summary>
public partial class EventHubsApplicationGroup : ProvisionableResource
{
    /// <summary>
    /// The Application Group name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The Unique identifier for application group.Supports
    /// SAS(SASKeyName=KeyName) or AAD(AADAppID=Guid).
    /// </summary>
    public BicepValue<string> ClientAppGroupIdentifier 
    {
        get { Initialize(); return _clientAppGroupIdentifier!; }
        set { Initialize(); _clientAppGroupIdentifier!.Assign(value); }
    }
    private BicepValue<string>? _clientAppGroupIdentifier;

    /// <summary>
    /// Determines if Application Group is allowed to create connection with
    /// namespace or not. Once the isEnabled is set to false, all the existing
    /// connections of application group gets dropped and no new connections
    /// will be allowed.
    /// </summary>
    public BicepValue<bool> IsEnabled 
    {
        get { Initialize(); return _isEnabled!; }
        set { Initialize(); _isEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isEnabled;

    /// <summary>
    /// List of group policies that define the behavior of application group.
    /// The policies can support resource governance scenarios such as
    /// limiting ingress or egress traffic.             Please note
    /// Azure.ResourceManager.EventHubs.Models.EventHubsApplicationGroupPolicy
    /// is the base class. According to the scenario, a derived class of the
    /// base class might need to be assigned here, or this property needs to
    /// be casted to one of the possible derived classes.             The
    /// available derived classes include
    /// Azure.ResourceManager.EventHubs.Models.EventHubsThrottlingPolicy.
    /// </summary>
    public BicepList<EventHubsApplicationGroupPolicy> Policies 
    {
        get { Initialize(); return _policies!; }
        set { Initialize(); _policies!.Assign(value); }
    }
    private BicepList<EventHubsApplicationGroupPolicy>? _policies;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// The geo-location where the resource lives.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent EventHubsNamespace.
    /// </summary>
    public EventHubsNamespace? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<EventHubsNamespace>? _parent;

    /// <summary>
    /// Creates a new EventHubsApplicationGroup.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the EventHubsApplicationGroup
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the EventHubsApplicationGroup.</param>
    public EventHubsApplicationGroup(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.EventHub/namespaces/applicationGroups", resourceVersion ?? "2024-01-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of EventHubsApplicationGroup.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _clientAppGroupIdentifier = DefineProperty<string>("ClientAppGroupIdentifier", ["properties", "clientAppGroupIdentifier"]);
        _isEnabled = DefineProperty<bool>("IsEnabled", ["properties", "isEnabled"]);
        _policies = DefineListProperty<EventHubsApplicationGroupPolicy>("Policies", ["properties", "policies"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<EventHubsNamespace>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported EventHubsApplicationGroup resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-01-01.
        /// </summary>
        public static readonly string V2024_01_01 = "2024-01-01";
    }

    /// <summary>
    /// Creates a reference to an existing EventHubsApplicationGroup.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the EventHubsApplicationGroup
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the EventHubsApplicationGroup.</param>
    /// <returns>The existing EventHubsApplicationGroup resource.</returns>
    public static EventHubsApplicationGroup FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
