// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// SystemTopic.
/// </summary>
public partial class SystemTopic : ProvisionableResource
{
    /// <summary>
    /// Name of the system topic.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets or sets the Location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Identity information for the resource.
    /// </summary>
    public ManagedServiceIdentity Identity 
    {
        get { Initialize(); return _identity!; }
        set { Initialize(); AssignOrReplace(ref _identity, value); }
    }
    private ManagedServiceIdentity? _identity;

    /// <summary>
    /// Source for the system topic.
    /// </summary>
    public BicepValue<ResourceIdentifier> Source 
    {
        get { Initialize(); return _source!; }
        set { Initialize(); _source!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _source;

    /// <summary>
    /// Gets or sets the Tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// TopicType for the system topic.
    /// </summary>
    public BicepValue<string> TopicType 
    {
        get { Initialize(); return _topicType!; }
        set { Initialize(); _topicType!.Assign(value); }
    }
    private BicepValue<string>? _topicType;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Metric resource id for the system topic.
    /// </summary>
    public BicepValue<Guid> MetricResourceId 
    {
        get { Initialize(); return _metricResourceId!; }
    }
    private BicepValue<Guid>? _metricResourceId;

    /// <summary>
    /// Provisioning state of the system topic.
    /// </summary>
    public BicepValue<EventGridResourceProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<EventGridResourceProvisioningState>? _provisioningState;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new SystemTopic.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SystemTopic resource.  This can be
    /// used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SystemTopic.</param>
    public SystemTopic(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.EventGrid/systemTopics", resourceVersion ?? "2022-06-15")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SystemTopic.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _identity = DefineModelProperty<ManagedServiceIdentity>("Identity", ["identity"]);
        _source = DefineProperty<ResourceIdentifier>("Source", ["properties", "source"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _topicType = DefineProperty<string>("TopicType", ["properties", "topicType"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _metricResourceId = DefineProperty<Guid>("MetricResourceId", ["properties", "metricResourceId"], isOutput: true);
        _provisioningState = DefineProperty<EventGridResourceProvisioningState>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }

    /// <summary>
    /// Supported SystemTopic resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2022-06-15.
        /// </summary>
        public static readonly string V2022_06_15 = "2022-06-15";

        /// <summary>
        /// 2021-12-01.
        /// </summary>
        public static readonly string V2021_12_01 = "2021-12-01";
    }

    /// <summary>
    /// Creates a reference to an existing SystemTopic.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SystemTopic resource.  This can be
    /// used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SystemTopic.</param>
    /// <returns>The existing SystemTopic resource.</returns>
    public static SystemTopic FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
