// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// PartnerNamespaceChannel.
/// </summary>
public partial class PartnerNamespaceChannel : ProvisionableResource
{
    /// <summary>
    /// Name of the channel.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The type of the event channel which represents the direction flow of
    /// events.
    /// </summary>
    public BicepValue<PartnerNamespaceChannelType> ChannelType 
    {
        get { Initialize(); return _channelType!; }
        set { Initialize(); _channelType!.Assign(value); }
    }
    private BicepValue<PartnerNamespaceChannelType>? _channelType;

    /// <summary>
    /// Expiration time of the channel. If this timer expires while the
    /// corresponding partner topic is never activated,             the
    /// channel and corresponding partner topic are deleted.
    /// </summary>
    public BicepValue<DateTimeOffset> ExpireOnIfNotActivated 
    {
        get { Initialize(); return _expireOnIfNotActivated!; }
        set { Initialize(); _expireOnIfNotActivated!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _expireOnIfNotActivated;

    /// <summary>
    /// Context or helpful message that can be used during the approval process
    /// by the subscriber.
    /// </summary>
    public BicepValue<string> MessageForActivation 
    {
        get { Initialize(); return _messageForActivation!; }
        set { Initialize(); _messageForActivation!.Assign(value); }
    }
    private BicepValue<string>? _messageForActivation;

    /// <summary>
    /// This property should be populated when channelType is
    /// PartnerDestination and represents information about the partner
    /// destination resource corresponding to the channel.             Please
    /// note Azure.ResourceManager.EventGrid.Models.PartnerDestinationInfo is
    /// the base class. According to the scenario, a derived class of the base
    /// class might need to be assigned here, or this property needs to be
    /// casted to one of the possible derived classes.             The
    /// available derived classes include
    /// Azure.ResourceManager.EventGrid.Models.WebhookPartnerDestinationInfo.
    /// </summary>
    public PartnerDestinationInfo PartnerDestinationInfo 
    {
        get { Initialize(); return _partnerDestinationInfo!; }
        set { Initialize(); AssignOrReplace(ref _partnerDestinationInfo, value); }
    }
    private PartnerDestinationInfo? _partnerDestinationInfo;

    /// <summary>
    /// This property should be populated when channelType is PartnerTopic and
    /// represents information about the partner topic resource corresponding
    /// to the channel.
    /// </summary>
    public PartnerTopicInfo PartnerTopicInfo 
    {
        get { Initialize(); return _partnerTopicInfo!; }
        set { Initialize(); AssignOrReplace(ref _partnerTopicInfo, value); }
    }
    private PartnerTopicInfo? _partnerTopicInfo;

    /// <summary>
    /// Provisioning state of the channel.
    /// </summary>
    public BicepValue<PartnerNamespaceChannelProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
        set { Initialize(); _provisioningState!.Assign(value); }
    }
    private BicepValue<PartnerNamespaceChannelProvisioningState>? _provisioningState;

    /// <summary>
    /// The readiness state of the corresponding partner topic.
    /// </summary>
    public BicepValue<PartnerTopicReadinessState> ReadinessState 
    {
        get { Initialize(); return _readinessState!; }
        set { Initialize(); _readinessState!.Assign(value); }
    }
    private BicepValue<PartnerTopicReadinessState>? _readinessState;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent PartnerNamespace.
    /// </summary>
    public PartnerNamespace? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<PartnerNamespace>? _parent;

    /// <summary>
    /// Creates a new PartnerNamespaceChannel.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the PartnerNamespaceChannel resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the PartnerNamespaceChannel.</param>
    public PartnerNamespaceChannel(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.EventGrid/partnerNamespaces/channels", resourceVersion ?? "2022-06-15")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of PartnerNamespaceChannel.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _channelType = DefineProperty<PartnerNamespaceChannelType>("ChannelType", ["properties", "channelType"]);
        _expireOnIfNotActivated = DefineProperty<DateTimeOffset>("ExpireOnIfNotActivated", ["properties", "expirationTimeIfNotActivatedUtc"]);
        _messageForActivation = DefineProperty<string>("MessageForActivation", ["properties", "messageForActivation"]);
        _partnerDestinationInfo = DefineModelProperty<PartnerDestinationInfo>("PartnerDestinationInfo", ["properties", "partnerDestinationInfo"]);
        _partnerTopicInfo = DefineModelProperty<PartnerTopicInfo>("PartnerTopicInfo", ["properties", "partnerTopicInfo"]);
        _provisioningState = DefineProperty<PartnerNamespaceChannelProvisioningState>("ProvisioningState", ["properties", "provisioningState"]);
        _readinessState = DefineProperty<PartnerTopicReadinessState>("ReadinessState", ["properties", "readinessState"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<PartnerNamespace>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported PartnerNamespaceChannel resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2022-06-15.
        /// </summary>
        public static readonly string V2022_06_15 = "2022-06-15";
    }

    /// <summary>
    /// Creates a reference to an existing PartnerNamespaceChannel.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the PartnerNamespaceChannel resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the PartnerNamespaceChannel.</param>
    /// <returns>The existing PartnerNamespaceChannel resource.</returns>
    public static PartnerNamespaceChannel FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
