// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// PartnerNamespace.
/// </summary>
public partial class PartnerNamespace : ProvisionableResource
{
    /// <summary>
    /// Name of the partner namespace.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets or sets the Location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// This can be used to restrict traffic from specific IPs instead of all
    /// IPs. Note: These are considered only if PublicNetworkAccess is enabled.
    /// </summary>
    public BicepList<EventGridInboundIPRule> InboundIPRules 
    {
        get { Initialize(); return _inboundIPRules!; }
        set { Initialize(); _inboundIPRules!.Assign(value); }
    }
    private BicepList<EventGridInboundIPRule>? _inboundIPRules;

    /// <summary>
    /// This boolean is used to enable or disable local auth. Default value is
    /// false. When the property is set to true, only AAD token will be used
    /// to authenticate if user is allowed to publish to the partner namespace.
    /// </summary>
    public BicepValue<bool> IsLocalAuthDisabled 
    {
        get { Initialize(); return _isLocalAuthDisabled!; }
        set { Initialize(); _isLocalAuthDisabled!.Assign(value); }
    }
    private BicepValue<bool>? _isLocalAuthDisabled;

    /// <summary>
    /// Minimum TLS version of the publisher allowed to publish to this partner
    /// namespace.
    /// </summary>
    public BicepValue<TlsVersion> MinimumTlsVersionAllowed 
    {
        get { Initialize(); return _minimumTlsVersionAllowed!; }
        set { Initialize(); _minimumTlsVersionAllowed!.Assign(value); }
    }
    private BicepValue<TlsVersion>? _minimumTlsVersionAllowed;

    /// <summary>
    /// The fully qualified ARM Id of the partner registration that should be
    /// associated with this partner namespace. This takes the following
    /// format:
    /// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerRegistrations/{partnerRegistrationName}.
    /// </summary>
    public BicepValue<ResourceIdentifier> PartnerRegistrationFullyQualifiedId 
    {
        get { Initialize(); return _partnerRegistrationFullyQualifiedId!; }
        set { Initialize(); _partnerRegistrationFullyQualifiedId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _partnerRegistrationFullyQualifiedId;

    /// <summary>
    /// This determines if events published to this partner namespace should
    /// use the source attribute in the event payload             or use the
    /// channel name in the header when matching to the partner topic. If none
    /// is specified, source attribute routing will be used to match the
    /// partner topic.
    /// </summary>
    public BicepValue<PartnerTopicRoutingMode> PartnerTopicRoutingMode 
    {
        get { Initialize(); return _partnerTopicRoutingMode!; }
        set { Initialize(); _partnerTopicRoutingMode!.Assign(value); }
    }
    private BicepValue<PartnerTopicRoutingMode>? _partnerTopicRoutingMode;

    /// <summary>
    /// This determines if traffic is allowed over public network. By default
    /// it is enabled.             You can further restrict to specific IPs by
    /// configuring &lt;seealso
    /// cref=&quot;P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PartnerNamespaceProperties.InboundIpRules&quot;
    /// /&gt;
    /// </summary>
    public BicepValue<EventGridPublicNetworkAccess> PublicNetworkAccess 
    {
        get { Initialize(); return _publicNetworkAccess!; }
        set { Initialize(); _publicNetworkAccess!.Assign(value); }
    }
    private BicepValue<EventGridPublicNetworkAccess>? _publicNetworkAccess;

    /// <summary>
    /// Gets or sets the Tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// Endpoint for the partner namespace.
    /// </summary>
    public BicepValue<Uri> Endpoint 
    {
        get { Initialize(); return _endpoint!; }
    }
    private BicepValue<Uri>? _endpoint;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// List of private endpoint connections.
    /// </summary>
    public BicepList<EventGridPrivateEndpointConnectionData> PrivateEndpointConnections 
    {
        get { Initialize(); return _privateEndpointConnections!; }
    }
    private BicepList<EventGridPrivateEndpointConnectionData>? _privateEndpointConnections;

    /// <summary>
    /// Provisioning state of the partner namespace.
    /// </summary>
    public BicepValue<PartnerNamespaceProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<PartnerNamespaceProvisioningState>? _provisioningState;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new PartnerNamespace.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the PartnerNamespace resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the PartnerNamespace.</param>
    public PartnerNamespace(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.EventGrid/partnerNamespaces", resourceVersion ?? "2022-06-15")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of PartnerNamespace.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _inboundIPRules = DefineListProperty<EventGridInboundIPRule>("InboundIPRules", ["properties", "inboundIpRules"]);
        _isLocalAuthDisabled = DefineProperty<bool>("IsLocalAuthDisabled", ["properties", "disableLocalAuth"]);
        _minimumTlsVersionAllowed = DefineProperty<TlsVersion>("MinimumTlsVersionAllowed", ["properties", "minimumTlsVersionAllowed"]);
        _partnerRegistrationFullyQualifiedId = DefineProperty<ResourceIdentifier>("PartnerRegistrationFullyQualifiedId", ["properties", "partnerRegistrationFullyQualifiedId"]);
        _partnerTopicRoutingMode = DefineProperty<PartnerTopicRoutingMode>("PartnerTopicRoutingMode", ["properties", "partnerTopicRoutingMode"]);
        _publicNetworkAccess = DefineProperty<EventGridPublicNetworkAccess>("PublicNetworkAccess", ["properties", "publicNetworkAccess"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _endpoint = DefineProperty<Uri>("Endpoint", ["properties", "endpoint"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _privateEndpointConnections = DefineListProperty<EventGridPrivateEndpointConnectionData>("PrivateEndpointConnections", ["properties", "privateEndpointConnections"], isOutput: true);
        _provisioningState = DefineProperty<PartnerNamespaceProvisioningState>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }

    /// <summary>
    /// Supported PartnerNamespace resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2022-06-15.
        /// </summary>
        public static readonly string V2022_06_15 = "2022-06-15";
    }

    /// <summary>
    /// Creates a reference to an existing PartnerNamespace.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the PartnerNamespace resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the PartnerNamespace.</param>
    /// <returns>The existing PartnerNamespace resource.</returns>
    public static PartnerNamespace FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
