// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// NamespaceTopicEventSubscription.
/// </summary>
public partial class NamespaceTopicEventSubscription : ProvisionableResource
{
    /// <summary>
    /// Name of the event subscription to be created. Event subscription names
    /// must be between 3 and 50 characters in length and use alphanumeric
    /// letters only.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Information about the delivery configuration of the event subscription.
    /// </summary>
    public DeliveryConfiguration DeliveryConfiguration 
    {
        get { Initialize(); return _deliveryConfiguration!; }
        set { Initialize(); AssignOrReplace(ref _deliveryConfiguration, value); }
    }
    private DeliveryConfiguration? _deliveryConfiguration;

    /// <summary>
    /// The event delivery schema for the event subscription.
    /// </summary>
    public BicepValue<DeliverySchema> EventDeliverySchema 
    {
        get { Initialize(); return _eventDeliverySchema!; }
        set { Initialize(); _eventDeliverySchema!.Assign(value); }
    }
    private BicepValue<DeliverySchema>? _eventDeliverySchema;

    /// <summary>
    /// Expiration time of the event subscription.
    /// </summary>
    public BicepValue<DateTimeOffset> ExpireOn 
    {
        get { Initialize(); return _expireOn!; }
        set { Initialize(); _expireOn!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _expireOn;

    /// <summary>
    /// Information about the filter for the event subscription.
    /// </summary>
    public FiltersConfiguration FiltersConfiguration 
    {
        get { Initialize(); return _filtersConfiguration!; }
        set { Initialize(); AssignOrReplace(ref _filtersConfiguration, value); }
    }
    private FiltersConfiguration? _filtersConfiguration;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Provisioning state of the event subscription.
    /// </summary>
    public BicepValue<SubscriptionProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<SubscriptionProvisioningState>? _provisioningState;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent NamespaceTopic.
    /// </summary>
    public NamespaceTopic? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<NamespaceTopic>? _parent;

    /// <summary>
    /// Creates a new NamespaceTopicEventSubscription.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the NamespaceTopicEventSubscription
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the NamespaceTopicEventSubscription.</param>
    public NamespaceTopicEventSubscription(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.EventGrid/namespaces/topics/eventSubscriptions", resourceVersion)
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// NamespaceTopicEventSubscription.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _deliveryConfiguration = DefineModelProperty<DeliveryConfiguration>("DeliveryConfiguration", ["properties", "deliveryConfiguration"]);
        _eventDeliverySchema = DefineProperty<DeliverySchema>("EventDeliverySchema", ["properties", "eventDeliverySchema"]);
        _expireOn = DefineProperty<DateTimeOffset>("ExpireOn", ["properties", "expirationTimeUtc"]);
        _filtersConfiguration = DefineModelProperty<FiltersConfiguration>("FiltersConfiguration", ["properties", "filtersConfiguration"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _provisioningState = DefineProperty<SubscriptionProvisioningState>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<NamespaceTopic>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Creates a reference to an existing NamespaceTopicEventSubscription.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the NamespaceTopicEventSubscription
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the NamespaceTopicEventSubscription.</param>
    /// <returns>The existing NamespaceTopicEventSubscription resource.</returns>
    public static NamespaceTopicEventSubscription FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
