// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// NamespaceTopic.
/// </summary>
public partial class NamespaceTopic : ProvisionableResource
{
    /// <summary>
    /// Name of the namespace topic.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Event retention for the namespace topic expressed in days. The property
    /// default value is 1 day.             Min event retention duration value
    /// is 1 day and max event retention duration value is 1 day.
    /// </summary>
    public BicepValue<int> EventRetentionInDays 
    {
        get { Initialize(); return _eventRetentionInDays!; }
        set { Initialize(); _eventRetentionInDays!.Assign(value); }
    }
    private BicepValue<int>? _eventRetentionInDays;

    /// <summary>
    /// This determines the format that is expected for incoming events
    /// published to the topic.
    /// </summary>
    public BicepValue<EventInputSchema> InputSchema 
    {
        get { Initialize(); return _inputSchema!; }
        set { Initialize(); _inputSchema!.Assign(value); }
    }
    private BicepValue<EventInputSchema>? _inputSchema;

    /// <summary>
    /// Publisher type of the namespace topic.
    /// </summary>
    public BicepValue<PublisherType> PublisherType 
    {
        get { Initialize(); return _publisherType!; }
        set { Initialize(); _publisherType!.Assign(value); }
    }
    private BicepValue<PublisherType>? _publisherType;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Provisioning state of the namespace topic.
    /// </summary>
    public BicepValue<NamespaceTopicProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<NamespaceTopicProvisioningState>? _provisioningState;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent EventGridNamespace.
    /// </summary>
    public EventGridNamespace? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<EventGridNamespace>? _parent;

    /// <summary>
    /// Creates a new NamespaceTopic.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the NamespaceTopic resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the NamespaceTopic.</param>
    public NamespaceTopic(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.EventGrid/namespaces/topics", resourceVersion)
    {
    }

    /// <summary>
    /// Define all the provisionable properties of NamespaceTopic.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _eventRetentionInDays = DefineProperty<int>("EventRetentionInDays", ["properties", "eventRetentionInDays"]);
        _inputSchema = DefineProperty<EventInputSchema>("InputSchema", ["properties", "inputSchema"]);
        _publisherType = DefineProperty<PublisherType>("PublisherType", ["properties", "publisherType"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _provisioningState = DefineProperty<NamespaceTopicProvisioningState>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<EventGridNamespace>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Creates a reference to an existing NamespaceTopic.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the NamespaceTopic resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the NamespaceTopic.</param>
    /// <returns>The existing NamespaceTopic resource.</returns>
    public static NamespaceTopic FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
