// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// Information about the webhook destination for an event subscription.
/// </summary>
public partial class WebHookEventSubscriptionDestination : EventSubscriptionDestination
{
    /// <summary>
    /// The URL that represents the endpoint of the destination of an event
    /// subscription.
    /// </summary>
    public BicepValue<Uri> Endpoint 
    {
        get { Initialize(); return _endpoint!; }
        set { Initialize(); _endpoint!.Assign(value); }
    }
    private BicepValue<Uri>? _endpoint;

    /// <summary>
    /// The base URL that represents the endpoint of the destination of an
    /// event subscription.
    /// </summary>
    public BicepValue<Uri> BaseEndpoint 
    {
        get { Initialize(); return _baseEndpoint!; }
    }
    private BicepValue<Uri>? _baseEndpoint;

    /// <summary>
    /// Maximum number of events per batch.
    /// </summary>
    public BicepValue<int> MaxEventsPerBatch 
    {
        get { Initialize(); return _maxEventsPerBatch!; }
        set { Initialize(); _maxEventsPerBatch!.Assign(value); }
    }
    private BicepValue<int>? _maxEventsPerBatch;

    /// <summary>
    /// Preferred batch size in Kilobytes.
    /// </summary>
    public BicepValue<int> PreferredBatchSizeInKilobytes 
    {
        get { Initialize(); return _preferredBatchSizeInKilobytes!; }
        set { Initialize(); _preferredBatchSizeInKilobytes!.Assign(value); }
    }
    private BicepValue<int>? _preferredBatchSizeInKilobytes;

    /// <summary>
    /// The Azure Active Directory Tenant ID to get the access token that will
    /// be included as the bearer token in delivery requests.
    /// </summary>
    public BicepValue<Guid> AzureActiveDirectoryTenantId 
    {
        get { Initialize(); return _azureActiveDirectoryTenantId!; }
        set { Initialize(); _azureActiveDirectoryTenantId!.Assign(value); }
    }
    private BicepValue<Guid>? _azureActiveDirectoryTenantId;

    /// <summary>
    /// The Azure Active Directory Application ID or URI to get the access
    /// token that will be included as the bearer token in delivery requests.
    /// </summary>
    public BicepValue<string> UriOrAzureActiveDirectoryApplicationId 
    {
        get { Initialize(); return _uriOrAzureActiveDirectoryApplicationId!; }
        set { Initialize(); _uriOrAzureActiveDirectoryApplicationId!.Assign(value); }
    }
    private BicepValue<string>? _uriOrAzureActiveDirectoryApplicationId;

    /// <summary>
    /// Delivery attribute details.             Please note
    /// Azure.ResourceManager.EventGrid.Models.DeliveryAttributeMapping is the
    /// base class. According to the scenario, a derived class of the base
    /// class might need to be assigned here, or this property needs to be
    /// casted to one of the possible derived classes.             The
    /// available derived classes include
    /// Azure.ResourceManager.EventGrid.Models.DynamicDeliveryAttributeMapping
    /// and
    /// Azure.ResourceManager.EventGrid.Models.StaticDeliveryAttributeMapping.
    /// </summary>
    public BicepList<DeliveryAttributeMapping> DeliveryAttributeMappings 
    {
        get { Initialize(); return _deliveryAttributeMappings!; }
        set { Initialize(); _deliveryAttributeMappings!.Assign(value); }
    }
    private BicepList<DeliveryAttributeMapping>? _deliveryAttributeMappings;

    /// <summary>
    /// Minimum TLS version that should be supported by webhook endpoint.
    /// </summary>
    public BicepValue<TlsVersion> MinimumTlsVersionAllowed 
    {
        get { Initialize(); return _minimumTlsVersionAllowed!; }
        set { Initialize(); _minimumTlsVersionAllowed!.Assign(value); }
    }
    private BicepValue<TlsVersion>? _minimumTlsVersionAllowed;

    /// <summary>
    /// Creates a new WebHookEventSubscriptionDestination.
    /// </summary>
    public WebHookEventSubscriptionDestination() : base()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// WebHookEventSubscriptionDestination.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        DefineProperty<string>("endpointType", ["endpointType"], defaultValue: "WebHook");
        _endpoint = DefineProperty<Uri>("Endpoint", ["properties", "endpointUrl"]);
        _baseEndpoint = DefineProperty<Uri>("BaseEndpoint", ["properties", "endpointBaseUrl"], isOutput: true);
        _maxEventsPerBatch = DefineProperty<int>("MaxEventsPerBatch", ["properties", "maxEventsPerBatch"]);
        _preferredBatchSizeInKilobytes = DefineProperty<int>("PreferredBatchSizeInKilobytes", ["properties", "preferredBatchSizeInKilobytes"]);
        _azureActiveDirectoryTenantId = DefineProperty<Guid>("AzureActiveDirectoryTenantId", ["properties", "azureActiveDirectoryTenantId"]);
        _uriOrAzureActiveDirectoryApplicationId = DefineProperty<string>("UriOrAzureActiveDirectoryApplicationId", ["properties", "azureActiveDirectoryApplicationIdOrUri"]);
        _deliveryAttributeMappings = DefineListProperty<DeliveryAttributeMapping>("DeliveryAttributeMappings", ["properties", "deliveryAttributeMappings"]);
        _minimumTlsVersionAllowed = DefineProperty<TlsVersion>("MinimumTlsVersionAllowed", ["properties", "minimumTlsVersionAllowed"]);
    }
}
