// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// Properties of the Topic Spaces Configuration.
/// </summary>
public partial class TopicSpacesConfiguration : ProvisionableConstruct
{
    /// <summary>
    /// Indicate if Topic Spaces Configuration is enabled for the namespace.
    /// Default is Disabled.
    /// </summary>
    public BicepValue<TopicSpacesConfigurationState> State 
    {
        get { Initialize(); return _state!; }
        set { Initialize(); _state!.Assign(value); }
    }
    private BicepValue<TopicSpacesConfigurationState>? _state;

    /// <summary>
    /// Fully qualified Azure Resource Id for the Event Grid Topic to which
    /// events will be routed to from TopicSpaces under a namespace.
    /// This property should be in the following format
    /// &apos;/subscriptions/{subId}/resourcegroups/{resourceGroupName}/providers/microsoft.EventGrid/topics/{topicName}&apos;.
    /// This topic should reside in the same region where
    /// namespace is located.
    /// </summary>
    public BicepValue<string> RouteTopicResourceId 
    {
        get { Initialize(); return _routeTopicResourceId!; }
        set { Initialize(); _routeTopicResourceId!.Assign(value); }
    }
    private BicepValue<string>? _routeTopicResourceId;

    /// <summary>
    /// The endpoint for the topic spaces configuration. This is a read-only
    /// property.
    /// </summary>
    public BicepValue<string> Hostname 
    {
        get { Initialize(); return _hostname!; }
    }
    private BicepValue<string>? _hostname;

    /// <summary>
    /// Routing enrichments for topic spaces configuration.
    /// </summary>
    public RoutingEnrichments RoutingEnrichments 
    {
        get { Initialize(); return _routingEnrichments!; }
        set { Initialize(); AssignOrReplace(ref _routingEnrichments, value); }
    }
    private RoutingEnrichments? _routingEnrichments;

    /// <summary>
    /// Client authentication settings for topic spaces configuration.
    /// </summary>
    public ClientAuthenticationSettings ClientAuthentication 
    {
        get { Initialize(); return _clientAuthentication!; }
        set { Initialize(); AssignOrReplace(ref _clientAuthentication, value); }
    }
    private ClientAuthenticationSettings? _clientAuthentication;

    /// <summary>
    /// The maximum session expiry in hours. The property default value is 1
    /// hour.             Min allowed value is 1 hour and max allowed value is
    /// 8 hours.
    /// </summary>
    public BicepValue<int> MaximumSessionExpiryInHours 
    {
        get { Initialize(); return _maximumSessionExpiryInHours!; }
        set { Initialize(); _maximumSessionExpiryInHours!.Assign(value); }
    }
    private BicepValue<int>? _maximumSessionExpiryInHours;

    /// <summary>
    /// The maximum number of sessions per authentication name. The property
    /// default value is 1.             Min allowed value is 1 and max allowed
    /// value is 100.
    /// </summary>
    public BicepValue<int> MaximumClientSessionsPerAuthenticationName 
    {
        get { Initialize(); return _maximumClientSessionsPerAuthenticationName!; }
        set { Initialize(); _maximumClientSessionsPerAuthenticationName!.Assign(value); }
    }
    private BicepValue<int>? _maximumClientSessionsPerAuthenticationName;

    /// <summary>
    /// Routing identity info for topic spaces configuration.
    /// </summary>
    public RoutingIdentityInfo RoutingIdentityInfo 
    {
        get { Initialize(); return _routingIdentityInfo!; }
        set { Initialize(); AssignOrReplace(ref _routingIdentityInfo, value); }
    }
    private RoutingIdentityInfo? _routingIdentityInfo;

    /// <summary>
    /// List of custom domain configurations for the namespace.
    /// </summary>
    public BicepList<CustomDomainConfiguration> CustomDomains 
    {
        get { Initialize(); return _customDomains!; }
        set { Initialize(); _customDomains!.Assign(value); }
    }
    private BicepList<CustomDomainConfiguration>? _customDomains;

    /// <summary>
    /// Creates a new TopicSpacesConfiguration.
    /// </summary>
    public TopicSpacesConfiguration()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of TopicSpacesConfiguration.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _state = DefineProperty<TopicSpacesConfigurationState>("State", ["state"]);
        _routeTopicResourceId = DefineProperty<string>("RouteTopicResourceId", ["routeTopicResourceId"]);
        _hostname = DefineProperty<string>("Hostname", ["hostname"], isOutput: true);
        _routingEnrichments = DefineModelProperty<RoutingEnrichments>("RoutingEnrichments", ["routingEnrichments"]);
        _clientAuthentication = DefineModelProperty<ClientAuthenticationSettings>("ClientAuthentication", ["clientAuthentication"]);
        _maximumSessionExpiryInHours = DefineProperty<int>("MaximumSessionExpiryInHours", ["maximumSessionExpiryInHours"]);
        _maximumClientSessionsPerAuthenticationName = DefineProperty<int>("MaximumClientSessionsPerAuthenticationName", ["maximumClientSessionsPerAuthenticationName"]);
        _routingIdentityInfo = DefineModelProperty<RoutingIdentityInfo>("RoutingIdentityInfo", ["routingIdentityInfo"]);
        _customDomains = DefineListProperty<CustomDomainConfiguration>("CustomDomains", ["customDomains"]);
    }
}
