// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// StringEndsWith Advanced Filter.
/// </summary>
public partial class StringEndsWithAdvancedFilter : AdvancedFilter
{
    /// <summary>
    /// The set of filter values.
    /// </summary>
    public BicepList<string> Values 
    {
        get { Initialize(); return _values!; }
        set { Initialize(); _values!.Assign(value); }
    }
    private BicepList<string>? _values;

    /// <summary>
    /// Creates a new StringEndsWithAdvancedFilter.
    /// </summary>
    public StringEndsWithAdvancedFilter() : base()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of StringEndsWithAdvancedFilter.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        DefineProperty<string>("operatorType", ["operatorType"], defaultValue: "StringEndsWith");
        _values = DefineListProperty<string>("Values", ["values"]);
    }
}
