// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// Information about the storage queue destination for an event subscription.
/// </summary>
public partial class StorageQueueEventSubscriptionDestination : EventSubscriptionDestination
{
    /// <summary>
    /// The Azure Resource ID of the storage account that contains the queue
    /// that is the destination of an event subscription.
    /// </summary>
    public BicepValue<ResourceIdentifier> ResourceId 
    {
        get { Initialize(); return _resourceId!; }
        set { Initialize(); _resourceId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _resourceId;

    /// <summary>
    /// The name of the Storage queue under a storage account that is the
    /// destination of an event subscription.
    /// </summary>
    public BicepValue<string> QueueName 
    {
        get { Initialize(); return _queueName!; }
        set { Initialize(); _queueName!.Assign(value); }
    }
    private BicepValue<string>? _queueName;

    /// <summary>
    /// Storage queue message time to live in seconds. This value cannot be
    /// zero or negative with the exception of using -1 to indicate that the
    /// Time To Live of the message is Infinite.
    /// </summary>
    public BicepValue<long> QueueMessageTimeToLiveInSeconds 
    {
        get { Initialize(); return _queueMessageTimeToLiveInSeconds!; }
        set { Initialize(); _queueMessageTimeToLiveInSeconds!.Assign(value); }
    }
    private BicepValue<long>? _queueMessageTimeToLiveInSeconds;

    /// <summary>
    /// Creates a new StorageQueueEventSubscriptionDestination.
    /// </summary>
    public StorageQueueEventSubscriptionDestination() : base()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// StorageQueueEventSubscriptionDestination.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        DefineProperty<string>("endpointType", ["endpointType"], defaultValue: "StorageQueue");
        _resourceId = DefineProperty<ResourceIdentifier>("ResourceId", ["properties", "resourceId"]);
        _queueName = DefineProperty<string>("QueueName", ["properties", "queueName"]);
        _queueMessageTimeToLiveInSeconds = DefineProperty<long>("QueueMessageTimeToLiveInSeconds", ["properties", "queueMessageTimeToLiveInSeconds"]);
    }
}
