// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// Information about the storage blob based dead letter destination.
/// </summary>
public partial class StorageBlobDeadLetterDestination : DeadLetterDestination
{
    /// <summary>
    /// The Azure Resource ID of the storage account that is the destination of
    /// the deadletter events.
    /// </summary>
    public BicepValue<ResourceIdentifier> ResourceId 
    {
        get { Initialize(); return _resourceId!; }
        set { Initialize(); _resourceId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _resourceId;

    /// <summary>
    /// The name of the Storage blob container that is the destination of the
    /// deadletter events.
    /// </summary>
    public BicepValue<string> BlobContainerName 
    {
        get { Initialize(); return _blobContainerName!; }
        set { Initialize(); _blobContainerName!.Assign(value); }
    }
    private BicepValue<string>? _blobContainerName;

    /// <summary>
    /// Creates a new StorageBlobDeadLetterDestination.
    /// </summary>
    public StorageBlobDeadLetterDestination() : base()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// StorageBlobDeadLetterDestination.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        DefineProperty<string>("endpointType", ["endpointType"], defaultValue: "StorageBlob");
        _resourceId = DefineProperty<ResourceIdentifier>("ResourceId", ["properties", "resourceId"]);
        _blobContainerName = DefineProperty<string>("BlobContainerName", ["properties", "blobContainerName"]);
    }
}
