// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// Static delivery attribute mapping details.
/// </summary>
public partial class StaticDeliveryAttributeMapping : DeliveryAttributeMapping
{
    /// <summary>
    /// Value of the delivery attribute.
    /// </summary>
    public BicepValue<string> Value 
    {
        get { Initialize(); return _value!; }
        set { Initialize(); _value!.Assign(value); }
    }
    private BicepValue<string>? _value;

    /// <summary>
    /// Boolean flag to tell if the attribute contains sensitive information .
    /// </summary>
    public BicepValue<bool> IsSecret 
    {
        get { Initialize(); return _isSecret!; }
        set { Initialize(); _isSecret!.Assign(value); }
    }
    private BicepValue<bool>? _isSecret;

    /// <summary>
    /// Creates a new StaticDeliveryAttributeMapping.
    /// </summary>
    public StaticDeliveryAttributeMapping() : base()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// StaticDeliveryAttributeMapping.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        DefineProperty<string>("type", ["type"], defaultValue: "Static");
        _value = DefineProperty<string>("Value", ["properties", "value"]);
        _isSecret = DefineProperty<bool>("IsSecret", ["properties", "isSecret"]);
    }
}
