// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// Information about the service bus topic destination for an event
/// subscription.
/// </summary>
public partial class ServiceBusTopicEventSubscriptionDestination : EventSubscriptionDestination
{
    /// <summary>
    /// The Azure Resource Id that represents the endpoint of the Service Bus
    /// Topic destination of an event subscription.
    /// </summary>
    public BicepValue<ResourceIdentifier> ResourceId 
    {
        get { Initialize(); return _resourceId!; }
        set { Initialize(); _resourceId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _resourceId;

    /// <summary>
    /// Delivery attribute details.             Please note
    /// Azure.ResourceManager.EventGrid.Models.DeliveryAttributeMapping is the
    /// base class. According to the scenario, a derived class of the base
    /// class might need to be assigned here, or this property needs to be
    /// casted to one of the possible derived classes.             The
    /// available derived classes include
    /// Azure.ResourceManager.EventGrid.Models.DynamicDeliveryAttributeMapping
    /// and
    /// Azure.ResourceManager.EventGrid.Models.StaticDeliveryAttributeMapping.
    /// </summary>
    public BicepList<DeliveryAttributeMapping> DeliveryAttributeMappings 
    {
        get { Initialize(); return _deliveryAttributeMappings!; }
        set { Initialize(); _deliveryAttributeMappings!.Assign(value); }
    }
    private BicepList<DeliveryAttributeMapping>? _deliveryAttributeMappings;

    /// <summary>
    /// Creates a new ServiceBusTopicEventSubscriptionDestination.
    /// </summary>
    public ServiceBusTopicEventSubscriptionDestination() : base()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ServiceBusTopicEventSubscriptionDestination.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        DefineProperty<string>("endpointType", ["endpointType"], defaultValue: "ServiceBusTopic");
        _resourceId = DefineProperty<ResourceIdentifier>("ResourceId", ["properties", "resourceId"]);
        _deliveryAttributeMappings = DefineListProperty<DeliveryAttributeMapping>("DeliveryAttributeMappings", ["properties", "deliveryAttributeMappings"]);
    }
}
