// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// Routing identity info for topic spaces configuration.
/// </summary>
public partial class RoutingIdentityInfo : ProvisionableConstruct
{
    /// <summary>
    /// Routing identity type for topic spaces configuration.
    /// </summary>
    public BicepValue<RoutingIdentityType> IdentityType 
    {
        get { Initialize(); return _identityType!; }
        set { Initialize(); _identityType!.Assign(value); }
    }
    private BicepValue<RoutingIdentityType>? _identityType;

    /// <summary>
    /// Gets or sets the user assigned identity.
    /// </summary>
    public BicepValue<string> UserAssignedIdentity 
    {
        get { Initialize(); return _userAssignedIdentity!; }
        set { Initialize(); _userAssignedIdentity!.Assign(value); }
    }
    private BicepValue<string>? _userAssignedIdentity;

    /// <summary>
    /// Creates a new RoutingIdentityInfo.
    /// </summary>
    public RoutingIdentityInfo()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of RoutingIdentityInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _identityType = DefineProperty<RoutingIdentityType>("IdentityType", ["type"]);
        _userAssignedIdentity = DefineProperty<string>("UserAssignedIdentity", ["userAssignedIdentity"]);
    }
}
