// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// Properties of the corresponding partner topic of a Channel.
/// </summary>
public partial class PartnerTopicInfo : ProvisionableConstruct
{
    /// <summary>
    /// Azure subscription ID of the subscriber. The partner topic associated
    /// with the channel will be             created under this Azure
    /// subscription.
    /// </summary>
    public BicepValue<Guid> AzureSubscriptionId 
    {
        get { Initialize(); return _azureSubscriptionId!; }
        set { Initialize(); _azureSubscriptionId!.Assign(value); }
    }
    private BicepValue<Guid>? _azureSubscriptionId;

    /// <summary>
    /// Azure Resource Group of the subscriber. The partner topic associated
    /// with the channel will be             created under this resource group.
    /// </summary>
    public BicepValue<string> ResourceGroupName 
    {
        get { Initialize(); return _resourceGroupName!; }
        set { Initialize(); _resourceGroupName!.Assign(value); }
    }
    private BicepValue<string>? _resourceGroupName;

    /// <summary>
    /// Name of the partner topic associated with the channel.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Event Type Information for the partner topic. This information is
    /// provided by the publisher and can be used by the
    /// subscriber to view different types of events that are
    /// published.
    /// </summary>
    public PartnerTopicEventTypeInfo EventTypeInfo 
    {
        get { Initialize(); return _eventTypeInfo!; }
        set { Initialize(); AssignOrReplace(ref _eventTypeInfo, value); }
    }
    private PartnerTopicEventTypeInfo? _eventTypeInfo;

    /// <summary>
    /// The source information is provided by the publisher to determine the
    /// scope or context from which the events             are originating.
    /// This information can be used by the subscriber during the approval
    /// process of the             created partner topic.
    /// </summary>
    public BicepValue<string> Source 
    {
        get { Initialize(); return _source!; }
        set { Initialize(); _source!.Assign(value); }
    }
    private BicepValue<string>? _source;

    /// <summary>
    /// Creates a new PartnerTopicInfo.
    /// </summary>
    public PartnerTopicInfo()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of PartnerTopicInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _azureSubscriptionId = DefineProperty<Guid>("AzureSubscriptionId", ["azureSubscriptionId"]);
        _resourceGroupName = DefineProperty<string>("ResourceGroupName", ["resourceGroupName"]);
        _name = DefineProperty<string>("Name", ["name"]);
        _eventTypeInfo = DefineModelProperty<PartnerTopicEventTypeInfo>("EventTypeInfo", ["eventTypeInfo"]);
        _source = DefineProperty<string>("Source", ["source"]);
    }
}
