// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// The event type information for Channels.
/// </summary>
public partial class PartnerTopicEventTypeInfo : ProvisionableConstruct
{
    /// <summary>
    /// The kind of event type used.
    /// </summary>
    public BicepValue<EventDefinitionKind> Kind 
    {
        get { Initialize(); return _kind!; }
        set { Initialize(); _kind!.Assign(value); }
    }
    private BicepValue<EventDefinitionKind>? _kind;

    /// <summary>
    /// A collection of inline event types for the resource. The inline event
    /// type keys are of type string which represents the name of the event.
    /// An example of a valid inline event name is
    /// &quot;Contoso.OrderCreated&quot;.             The inline event type
    /// values are of type InlineEventProperties and will contain additional
    /// information for every inline event type.
    /// </summary>
    public BicepDictionary<InlineEventProperties> InlineEventTypes 
    {
        get { Initialize(); return _inlineEventTypes!; }
        set { Initialize(); _inlineEventTypes!.Assign(value); }
    }
    private BicepDictionary<InlineEventProperties>? _inlineEventTypes;

    /// <summary>
    /// Creates a new PartnerTopicEventTypeInfo.
    /// </summary>
    public PartnerTopicEventTypeInfo()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of PartnerTopicEventTypeInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _kind = DefineProperty<EventDefinitionKind>("Kind", ["kind"]);
        _inlineEventTypes = DefineDictionaryProperty<InlineEventProperties>("InlineEventTypes", ["inlineEventTypes"]);
    }
}
