// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// NumberIn Advanced Filter.
/// </summary>
public partial class NumberInAdvancedFilter : AdvancedFilter
{
    /// <summary>
    /// The set of filter values.
    /// </summary>
    public BicepList<double> Values 
    {
        get { Initialize(); return _values!; }
        set { Initialize(); _values!.Assign(value); }
    }
    private BicepList<double>? _values;

    /// <summary>
    /// Creates a new NumberInAdvancedFilter.
    /// </summary>
    public NumberInAdvancedFilter() : base()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of NumberInAdvancedFilter.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        DefineProperty<string>("operatorType", ["operatorType"], defaultValue: "NumberIn");
        _values = DefineListProperty<double>("Values", ["values"]);
    }
}
