// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// NumberGreaterThanOrEquals Advanced Filter.
/// </summary>
public partial class NumberGreaterThanOrEqualsAdvancedFilter : AdvancedFilter
{
    /// <summary>
    /// The filter value.
    /// </summary>
    public BicepValue<double> Value 
    {
        get { Initialize(); return _value!; }
        set { Initialize(); _value!.Assign(value); }
    }
    private BicepValue<double>? _value;

    /// <summary>
    /// Creates a new NumberGreaterThanOrEqualsAdvancedFilter.
    /// </summary>
    public NumberGreaterThanOrEqualsAdvancedFilter() : base()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// NumberGreaterThanOrEqualsAdvancedFilter.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        DefineProperty<string>("operatorType", ["operatorType"], defaultValue: "NumberGreaterThanOrEquals");
        _value = DefineProperty<double>("Value", ["value"]);
    }
}
