// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// NumberGreaterThan Advanced Filter.
/// </summary>
public partial class NumberGreaterThanAdvancedFilter : AdvancedFilter
{
    /// <summary>
    /// The filter value.
    /// </summary>
    public BicepValue<double> Value 
    {
        get { Initialize(); return _value!; }
        set { Initialize(); _value!.Assign(value); }
    }
    private BicepValue<double>? _value;

    /// <summary>
    /// Creates a new NumberGreaterThanAdvancedFilter.
    /// </summary>
    public NumberGreaterThanAdvancedFilter() : base()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// NumberGreaterThanAdvancedFilter.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        DefineProperty<string>("operatorType", ["operatorType"], defaultValue: "NumberGreaterThan");
        _value = DefineProperty<double>("Value", ["value"]);
    }
}
