// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// Information about the Namespace Topic destination for an event subscription.
/// </summary>
public partial class NamespaceTopicEventSubscriptionDestination : EventSubscriptionDestination
{
    /// <summary>
    /// The Azure resource Id that represents the endpoint of the Event Grid
    /// Namespace Topic destination of an event subscription.             This
    /// field is required and the Namespace Topic resource listed must already
    /// exist.             The resource ARM Id should follow this pattern:
    /// /subscriptions/{AzureSubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.EventGrid/namespaces/{NamespaceName}/topics/{TopicName}.
    /// </summary>
    public BicepValue<ResourceIdentifier> ResourceId 
    {
        get { Initialize(); return _resourceId!; }
        set { Initialize(); _resourceId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _resourceId;

    /// <summary>
    /// Creates a new NamespaceTopicEventSubscriptionDestination.
    /// </summary>
    public NamespaceTopicEventSubscriptionDestination() : base()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// NamespaceTopicEventSubscriptionDestination.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        DefineProperty<string>("endpointType", ["endpointType"], defaultValue: "NamespaceTopic");
        _resourceId = DefineProperty<ResourceIdentifier>("ResourceId", ["properties", "resourceId"]);
    }
}
