// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// Represents available Sku pricing tiers.
/// </summary>
public partial class NamespaceSku : ProvisionableConstruct
{
    /// <summary>
    /// The name of the SKU.
    /// </summary>
    public BicepValue<EventGridSkuName> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<EventGridSkuName>? _name;

    /// <summary>
    /// Specifies the number of Throughput Units that defines the capacity for
    /// the namespace. The property default value is             1 which
    /// signifies 1 Throughput Unit = 1MB/s ingress and 2MB/s egress per
    /// namespace. Min capacity is 1 and             max allowed capacity is
    /// 20.
    /// </summary>
    public BicepValue<int> Capacity 
    {
        get { Initialize(); return _capacity!; }
        set { Initialize(); _capacity!.Assign(value); }
    }
    private BicepValue<int>? _capacity;

    /// <summary>
    /// Creates a new NamespaceSku.
    /// </summary>
    public NamespaceSku()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of NamespaceSku.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<EventGridSkuName>("Name", ["name"]);
        _capacity = DefineProperty<int>("Capacity", ["capacity"]);
    }
}
