// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// Additional information about every inline event.
/// </summary>
public partial class InlineEventProperties : ProvisionableConstruct
{
    /// <summary>
    /// The description for the inline event.
    /// </summary>
    public BicepValue<string> Description 
    {
        get { Initialize(); return _description!; }
        set { Initialize(); _description!.Assign(value); }
    }
    private BicepValue<string>? _description;

    /// <summary>
    /// The displayName for the inline event.
    /// </summary>
    public BicepValue<string> DisplayName 
    {
        get { Initialize(); return _displayName!; }
        set { Initialize(); _displayName!.Assign(value); }
    }
    private BicepValue<string>? _displayName;

    /// <summary>
    /// The documentationUrl for the inline event.
    /// </summary>
    public BicepValue<Uri> DocumentationUri 
    {
        get { Initialize(); return _documentationUri!; }
        set { Initialize(); _documentationUri!.Assign(value); }
    }
    private BicepValue<Uri>? _documentationUri;

    /// <summary>
    /// The dataSchemaUrl for the inline event.
    /// </summary>
    public BicepValue<Uri> DataSchemaUri 
    {
        get { Initialize(); return _dataSchemaUri!; }
        set { Initialize(); _dataSchemaUri!.Assign(value); }
    }
    private BicepValue<Uri>? _dataSchemaUri;

    /// <summary>
    /// Creates a new InlineEventProperties.
    /// </summary>
    public InlineEventProperties()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of InlineEventProperties.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _description = DefineProperty<string>("Description", ["description"]);
        _displayName = DefineProperty<string>("DisplayName", ["displayName"]);
        _documentationUri = DefineProperty<Uri>("DocumentationUri", ["documentationUrl"]);
        _dataSchemaUri = DefineProperty<Uri>("DataSchemaUri", ["dataSchemaUrl"]);
    }
}
