// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// Information about the retry policy for an event subscription.
/// </summary>
public partial class EventSubscriptionRetryPolicy : ProvisionableConstruct
{
    /// <summary>
    /// Maximum number of delivery retry attempts for events.
    /// </summary>
    public BicepValue<int> MaxDeliveryAttempts 
    {
        get { Initialize(); return _maxDeliveryAttempts!; }
        set { Initialize(); _maxDeliveryAttempts!.Assign(value); }
    }
    private BicepValue<int>? _maxDeliveryAttempts;

    /// <summary>
    /// Time To Live (in minutes) for events.
    /// </summary>
    public BicepValue<int> EventTimeToLiveInMinutes 
    {
        get { Initialize(); return _eventTimeToLiveInMinutes!; }
        set { Initialize(); _eventTimeToLiveInMinutes!.Assign(value); }
    }
    private BicepValue<int>? _eventTimeToLiveInMinutes;

    /// <summary>
    /// Creates a new EventSubscriptionRetryPolicy.
    /// </summary>
    public EventSubscriptionRetryPolicy()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of EventSubscriptionRetryPolicy.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _maxDeliveryAttempts = DefineProperty<int>("MaxDeliveryAttempts", ["maxDeliveryAttempts"]);
        _eventTimeToLiveInMinutes = DefineProperty<int>("EventTimeToLiveInMinutes", ["eventTimeToLiveInMinutes"]);
    }
}
