// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// The identity information with the event subscription.
/// </summary>
public partial class EventSubscriptionIdentity : ProvisionableConstruct
{
    /// <summary>
    /// The type of managed identity used. Can be either
    /// &apos;SystemAssigned&apos; or &apos;UserAssigned&apos;.
    /// </summary>
    public BicepValue<EventSubscriptionIdentityType> IdentityType 
    {
        get { Initialize(); return _identityType!; }
        set { Initialize(); _identityType!.Assign(value); }
    }
    private BicepValue<EventSubscriptionIdentityType>? _identityType;

    /// <summary>
    /// The user identity associated with the resource.
    /// </summary>
    public BicepValue<string> UserAssignedIdentity 
    {
        get { Initialize(); return _userAssignedIdentity!; }
        set { Initialize(); _userAssignedIdentity!.Assign(value); }
    }
    private BicepValue<string>? _userAssignedIdentity;

    /// <summary>
    /// Creates a new EventSubscriptionIdentity.
    /// </summary>
    public EventSubscriptionIdentity()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of EventSubscriptionIdentity.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _identityType = DefineProperty<EventSubscriptionIdentityType>("IdentityType", ["type"]);
        _userAssignedIdentity = DefineProperty<string>("UserAssignedIdentity", ["userAssignedIdentity"]);
    }
}
