// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// ConnectionState information.
/// </summary>
public partial class EventGridPrivateEndpointConnectionState : ProvisionableConstruct
{
    /// <summary>
    /// Status of the connection.
    /// </summary>
    public BicepValue<EventGridPrivateEndpointPersistedConnectionStatus> Status 
    {
        get { Initialize(); return _status!; }
        set { Initialize(); _status!.Assign(value); }
    }
    private BicepValue<EventGridPrivateEndpointPersistedConnectionStatus>? _status;

    /// <summary>
    /// Description of the connection state.
    /// </summary>
    public BicepValue<string> Description 
    {
        get { Initialize(); return _description!; }
        set { Initialize(); _description!.Assign(value); }
    }
    private BicepValue<string>? _description;

    /// <summary>
    /// Actions required (if any).
    /// </summary>
    public BicepValue<string> ActionsRequired 
    {
        get { Initialize(); return _actionsRequired!; }
        set { Initialize(); _actionsRequired!.Assign(value); }
    }
    private BicepValue<string>? _actionsRequired;

    /// <summary>
    /// Creates a new EventGridPrivateEndpointConnectionState.
    /// </summary>
    public EventGridPrivateEndpointConnectionState()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// EventGridPrivateEndpointConnectionState.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _status = DefineProperty<EventGridPrivateEndpointPersistedConnectionStatus>("Status", ["status"]);
        _description = DefineProperty<string>("Description", ["description"]);
        _actionsRequired = DefineProperty<string>("ActionsRequired", ["actionsRequired"]);
    }
}
