// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// The EventGridInboundIPRule.
/// </summary>
public partial class EventGridInboundIPRule : ProvisionableConstruct
{
    /// <summary>
    /// IP Address in CIDR notation e.g., 10.0.0.0/8.
    /// </summary>
    public BicepValue<string> IPMask 
    {
        get { Initialize(); return _iPMask!; }
        set { Initialize(); _iPMask!.Assign(value); }
    }
    private BicepValue<string>? _iPMask;

    /// <summary>
    /// Action to perform based on the match or no match of the IpMask.
    /// </summary>
    public BicepValue<EventGridIPActionType> Action 
    {
        get { Initialize(); return _action!; }
        set { Initialize(); _action!.Assign(value); }
    }
    private BicepValue<EventGridIPActionType>? _action;

    /// <summary>
    /// Creates a new EventGridInboundIPRule.
    /// </summary>
    public EventGridInboundIPRule()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of EventGridInboundIPRule.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _iPMask = DefineProperty<string>("IPMask", ["ipMask"]);
        _action = DefineProperty<EventGridIPActionType>("Action", ["action"]);
    }
}
