// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// The DynamicRoutingEnrichment.
/// </summary>
public partial class DynamicRoutingEnrichment : ProvisionableConstruct
{
    /// <summary>
    /// Dynamic routing enrichment key.
    /// </summary>
    public BicepValue<string> Key 
    {
        get { Initialize(); return _key!; }
        set { Initialize(); _key!.Assign(value); }
    }
    private BicepValue<string>? _key;

    /// <summary>
    /// Dynamic routing enrichment value.
    /// </summary>
    public BicepValue<string> Value 
    {
        get { Initialize(); return _value!; }
        set { Initialize(); _value!.Assign(value); }
    }
    private BicepValue<string>? _value;

    /// <summary>
    /// Creates a new DynamicRoutingEnrichment.
    /// </summary>
    public DynamicRoutingEnrichment()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of DynamicRoutingEnrichment.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _key = DefineProperty<string>("Key", ["key"]);
        _value = DefineProperty<string>("Value", ["value"]);
    }
}
