// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// Dynamic delivery attribute mapping details.
/// </summary>
public partial class DynamicDeliveryAttributeMapping : DeliveryAttributeMapping
{
    /// <summary>
    /// JSON path in the event which contains attribute value.
    /// </summary>
    public BicepValue<string> SourceField 
    {
        get { Initialize(); return _sourceField!; }
        set { Initialize(); _sourceField!.Assign(value); }
    }
    private BicepValue<string>? _sourceField;

    /// <summary>
    /// Creates a new DynamicDeliveryAttributeMapping.
    /// </summary>
    public DynamicDeliveryAttributeMapping() : base()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// DynamicDeliveryAttributeMapping.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        DefineProperty<string>("type", ["type"], defaultValue: "Dynamic");
        _sourceField = DefineProperty<string>("SourceField", ["properties", "sourceField"]);
    }
}
