// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// Information about the delivery for an event subscription with resource
/// identity.
/// </summary>
public partial class DeliveryWithResourceIdentity : ProvisionableConstruct
{
    /// <summary>
    /// The identity to use when delivering events.
    /// </summary>
    public EventSubscriptionIdentity Identity 
    {
        get { Initialize(); return _identity!; }
        set { Initialize(); AssignOrReplace(ref _identity, value); }
    }
    private EventSubscriptionIdentity? _identity;

    /// <summary>
    /// Information about the destination where events have to be delivered for
    /// the event subscription.             Uses the managed identity setup on
    /// the parent resource (namely, topic or domain) to acquire the
    /// authentication tokens being used during delivery.             Please
    /// note
    /// Azure.ResourceManager.EventGrid.Models.EventSubscriptionDestination is
    /// the base class. According to the scenario, a derived class of the base
    /// class might need to be assigned here, or this property needs to be
    /// casted to one of the possible derived classes.             The
    /// available derived classes include
    /// Azure.ResourceManager.EventGrid.Models.AzureFunctionEventSubscriptionDestination,
    /// Azure.ResourceManager.EventGrid.Models.EventHubEventSubscriptionDestination,
    /// Azure.ResourceManager.EventGrid.Models.HybridConnectionEventSubscriptionDestination,
    /// Azure.ResourceManager.EventGrid.Models.MonitorAlertEventSubscriptionDestination,
    /// Azure.ResourceManager.EventGrid.Models.NamespaceTopicEventSubscriptionDestination,
    /// Azure.ResourceManager.EventGrid.Models.PartnerEventSubscriptionDestination,
    /// Azure.ResourceManager.EventGrid.Models.ServiceBusQueueEventSubscriptionDestination,
    /// Azure.ResourceManager.EventGrid.Models.ServiceBusTopicEventSubscriptionDestination,
    /// Azure.ResourceManager.EventGrid.Models.StorageQueueEventSubscriptionDestination
    /// and
    /// Azure.ResourceManager.EventGrid.Models.WebHookEventSubscriptionDestination.
    /// </summary>
    public EventSubscriptionDestination Destination 
    {
        get { Initialize(); return _destination!; }
        set { Initialize(); AssignOrReplace(ref _destination, value); }
    }
    private EventSubscriptionDestination? _destination;

    /// <summary>
    /// Creates a new DeliveryWithResourceIdentity.
    /// </summary>
    public DeliveryWithResourceIdentity()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of DeliveryWithResourceIdentity.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _identity = DefineModelProperty<EventSubscriptionIdentity>("Identity", ["identity"]);
        _destination = DefineModelProperty<EventSubscriptionDestination>("Destination", ["destination"]);
    }
}
