// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// Properties of the delivery configuration information of the event
/// subscription.
/// </summary>
public partial class DeliveryConfiguration : ProvisionableConstruct
{
    /// <summary>
    /// Delivery mode of the event subscription.
    /// </summary>
    public BicepValue<DeliveryMode> DeliveryMode 
    {
        get { Initialize(); return _deliveryMode!; }
        set { Initialize(); _deliveryMode!.Assign(value); }
    }
    private BicepValue<DeliveryMode>? _deliveryMode;

    /// <summary>
    /// This property should be populated when deliveryMode is queue and
    /// represents information about the queue subscription.
    /// </summary>
    public QueueInfo Queue 
    {
        get { Initialize(); return _queue!; }
        set { Initialize(); AssignOrReplace(ref _queue, value); }
    }
    private QueueInfo? _queue;

    /// <summary>
    /// This property should be populated when deliveryMode is push and
    /// represents information about the push subscription.
    /// </summary>
    public PushInfo Push 
    {
        get { Initialize(); return _push!; }
        set { Initialize(); AssignOrReplace(ref _push, value); }
    }
    private PushInfo? _push;

    /// <summary>
    /// Creates a new DeliveryConfiguration.
    /// </summary>
    public DeliveryConfiguration()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of DeliveryConfiguration.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _deliveryMode = DefineProperty<DeliveryMode>("DeliveryMode", ["deliveryMode"]);
        _queue = DefineModelProperty<QueueInfo>("Queue", ["queue"]);
        _push = DefineModelProperty<PushInfo>("Push", ["push"]);
    }
}
