// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// Delivery attribute mapping details.             Please note
/// Azure.ResourceManager.EventGrid.Models.DeliveryAttributeMapping is the
/// base class. According to the scenario, a derived class of the base class
/// might need to be assigned here, or this property needs to be casted to one
/// of the possible derived classes.             The available derived classes
/// include
/// Azure.ResourceManager.EventGrid.Models.DynamicDeliveryAttributeMapping and
/// Azure.ResourceManager.EventGrid.Models.StaticDeliveryAttributeMapping.
/// </summary>
public partial class DeliveryAttributeMapping : ProvisionableConstruct
{
    /// <summary>
    /// Name of the delivery attribute or header.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Creates a new DeliveryAttributeMapping.
    /// </summary>
    public DeliveryAttributeMapping()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of DeliveryAttributeMapping.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
    }
}
