// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// Information about the deadletter destination with resource identity.
/// </summary>
public partial class DeadLetterWithResourceIdentity : ProvisionableConstruct
{
    /// <summary>
    /// The identity to use when dead-lettering events.
    /// </summary>
    public EventSubscriptionIdentity Identity 
    {
        get { Initialize(); return _identity!; }
        set { Initialize(); AssignOrReplace(ref _identity, value); }
    }
    private EventSubscriptionIdentity? _identity;

    /// <summary>
    /// Information about the destination where events have to be delivered for
    /// the event subscription.             Uses the managed identity setup on
    /// the parent resource (namely, topic or domain) to acquire the
    /// authentication tokens being used during dead-lettering.
    /// Please note
    /// Azure.ResourceManager.EventGrid.Models.DeadLetterDestination is the
    /// base class. According to the scenario, a derived class of the base
    /// class might need to be assigned here, or this property needs to be
    /// casted to one of the possible derived classes.             The
    /// available derived classes include
    /// Azure.ResourceManager.EventGrid.Models.StorageBlobDeadLetterDestination.
    /// </summary>
    public DeadLetterDestination DeadLetterDestination 
    {
        get { Initialize(); return _deadLetterDestination!; }
        set { Initialize(); AssignOrReplace(ref _deadLetterDestination, value); }
    }
    private DeadLetterDestination? _deadLetterDestination;

    /// <summary>
    /// Creates a new DeadLetterWithResourceIdentity.
    /// </summary>
    public DeadLetterWithResourceIdentity()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// DeadLetterWithResourceIdentity.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _identity = DefineModelProperty<EventSubscriptionIdentity>("Identity", ["identity"]);
        _deadLetterDestination = DefineModelProperty<DeadLetterDestination>("DeadLetterDestination", ["deadLetterDestination"]);
    }
}
