// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// Custom JWT authentication settings for namespace resource.
/// </summary>
public partial class CustomJwtAuthenticationSettings : ProvisionableConstruct
{
    /// <summary>
    /// Expected JWT token issuer.
    /// </summary>
    public BicepValue<string> TokenIssuer 
    {
        get { Initialize(); return _tokenIssuer!; }
        set { Initialize(); _tokenIssuer!.Assign(value); }
    }
    private BicepValue<string>? _tokenIssuer;

    /// <summary>
    /// Information about the certificate that is used for token validation. We
    /// currently support maximum 2 certificates.
    /// </summary>
    public BicepList<IssuerCertificateInfo> IssuerCertificates 
    {
        get { Initialize(); return _issuerCertificates!; }
        set { Initialize(); _issuerCertificates!.Assign(value); }
    }
    private BicepList<IssuerCertificateInfo>? _issuerCertificates;

    /// <summary>
    /// Creates a new CustomJwtAuthenticationSettings.
    /// </summary>
    public CustomJwtAuthenticationSettings()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// CustomJwtAuthenticationSettings.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _tokenIssuer = DefineProperty<string>("TokenIssuer", ["tokenIssuer"]);
        _issuerCertificates = DefineListProperty<IssuerCertificateInfo>("IssuerCertificates", ["issuerCertificates"]);
    }
}
