// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// The identity information for retrieving the certificate for custom JWT
/// authentication.
/// </summary>
public partial class CustomJwtAuthenticationManagedIdentity : ProvisionableConstruct
{
    /// <summary>
    /// The type of managed identity used. Can be either
    /// &apos;SystemAssigned&apos; or &apos;UserAssigned&apos;.
    /// </summary>
    public BicepValue<CustomJwtAuthenticationManagedIdentityType> IdentityType 
    {
        get { Initialize(); return _identityType!; }
        set { Initialize(); _identityType!.Assign(value); }
    }
    private BicepValue<CustomJwtAuthenticationManagedIdentityType>? _identityType;

    /// <summary>
    /// The user identity associated with the resource.
    /// </summary>
    public BicepValue<string> UserAssignedIdentity 
    {
        get { Initialize(); return _userAssignedIdentity!; }
        set { Initialize(); _userAssignedIdentity!.Assign(value); }
    }
    private BicepValue<string>? _userAssignedIdentity;

    /// <summary>
    /// Creates a new CustomJwtAuthenticationManagedIdentity.
    /// </summary>
    public CustomJwtAuthenticationManagedIdentity()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// CustomJwtAuthenticationManagedIdentity.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _identityType = DefineProperty<CustomJwtAuthenticationManagedIdentityType>("IdentityType", ["type"]);
        _userAssignedIdentity = DefineProperty<string>("UserAssignedIdentity", ["userAssignedIdentity"]);
    }
}
