// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// The identity information for retrieving the certificate for the custom
/// domain.
/// </summary>
public partial class CustomDomainIdentity : ProvisionableConstruct
{
    /// <summary>
    /// The type of managed identity used. Can be either
    /// &apos;SystemAssigned&apos; or &apos;UserAssigned&apos;.
    /// </summary>
    public BicepValue<CustomDomainIdentityType> IdentityType 
    {
        get { Initialize(); return _identityType!; }
        set { Initialize(); _identityType!.Assign(value); }
    }
    private BicepValue<CustomDomainIdentityType>? _identityType;

    /// <summary>
    /// The user identity associated with the resource.
    /// </summary>
    public BicepValue<string> UserAssignedIdentity 
    {
        get { Initialize(); return _userAssignedIdentity!; }
        set { Initialize(); _userAssignedIdentity!.Assign(value); }
    }
    private BicepValue<string>? _userAssignedIdentity;

    /// <summary>
    /// Creates a new CustomDomainIdentity.
    /// </summary>
    public CustomDomainIdentity()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CustomDomainIdentity.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _identityType = DefineProperty<CustomDomainIdentityType>("IdentityType", ["type"]);
        _userAssignedIdentity = DefineProperty<string>("UserAssignedIdentity", ["userAssignedIdentity"]);
    }
}
