// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// A custom domain configuration that allows users to publish to their own
/// domain name.
/// </summary>
public partial class CustomDomainConfiguration : ProvisionableConstruct
{
    /// <summary>
    /// Fully Qualified Domain Name (FQDN) for the custom domain.
    /// </summary>
    public BicepValue<string> FullyQualifiedDomainName 
    {
        get { Initialize(); return _fullyQualifiedDomainName!; }
        set { Initialize(); _fullyQualifiedDomainName!.Assign(value); }
    }
    private BicepValue<string>? _fullyQualifiedDomainName;

    /// <summary>
    /// Validation state for the custom domain. This is a read only property
    /// and is initially set to &apos;Pending&apos; and will be updated to
    /// &apos;Approved&apos; by Event Grid only after ownership of the domain
    /// name has been successfully validated.
    /// </summary>
    public BicepValue<CustomDomainValidationState> ValidationState 
    {
        get { Initialize(); return _validationState!; }
        set { Initialize(); _validationState!.Assign(value); }
    }
    private BicepValue<CustomDomainValidationState>? _validationState;

    /// <summary>
    /// Identity info for accessing the certificate for the custom domain. This
    /// identity info must match an identity that has been set on the
    /// namespace.
    /// </summary>
    public CustomDomainIdentity Identity 
    {
        get { Initialize(); return _identity!; }
        set { Initialize(); AssignOrReplace(ref _identity, value); }
    }
    private CustomDomainIdentity? _identity;

    /// <summary>
    /// The URL for the certificate that is used for publishing to the custom
    /// domain. We currently support certificates stored in Azure Key Vault
    /// only. While certificate URL can be either             versioned URL of
    /// the following format
    /// https://{key-vault-name}.vault.azure.net/certificates/{certificate-name}/{version-id},
    /// or unversioned URL of the following format (e.g.,
    /// https://contosovault.vault.azure.net/certificates/contosocert,
    /// we support unversioned certificate URL only (e.g.,
    /// https://contosovault.vault.azure.net/certificates/contosocert)
    /// </summary>
    public BicepValue<Uri> CertificateUri 
    {
        get { Initialize(); return _certificateUri!; }
        set { Initialize(); _certificateUri!.Assign(value); }
    }
    private BicepValue<Uri>? _certificateUri;

    /// <summary>
    /// Expected DNS TXT record name. Event Grid will check for a TXT record
    /// with this name in the DNS record set of the custom domain name to
    /// prove ownership over the domain.             The values under this TXT
    /// record must contain the expected TXT record value.
    /// </summary>
    public BicepValue<string> ExpectedTxtRecordName 
    {
        get { Initialize(); return _expectedTxtRecordName!; }
        set { Initialize(); _expectedTxtRecordName!.Assign(value); }
    }
    private BicepValue<string>? _expectedTxtRecordName;

    /// <summary>
    /// Expected DNS TXT record value. Event Grid will check for a TXT record
    /// with this value in the DNS record set of the custom domain name to
    /// prove ownership over the domain.
    /// </summary>
    public BicepValue<string> ExpectedTxtRecordValue 
    {
        get { Initialize(); return _expectedTxtRecordValue!; }
        set { Initialize(); _expectedTxtRecordValue!.Assign(value); }
    }
    private BicepValue<string>? _expectedTxtRecordValue;

    /// <summary>
    /// Creates a new CustomDomainConfiguration.
    /// </summary>
    public CustomDomainConfiguration()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CustomDomainConfiguration.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _fullyQualifiedDomainName = DefineProperty<string>("FullyQualifiedDomainName", ["fullyQualifiedDomainName"]);
        _validationState = DefineProperty<CustomDomainValidationState>("ValidationState", ["validationState"]);
        _identity = DefineModelProperty<CustomDomainIdentity>("Identity", ["identity"]);
        _certificateUri = DefineProperty<Uri>("CertificateUri", ["certificateUrl"]);
        _expectedTxtRecordName = DefineProperty<string>("ExpectedTxtRecordName", ["expectedTxtRecordName"]);
        _expectedTxtRecordValue = DefineProperty<string>("ExpectedTxtRecordValue", ["expectedTxtRecordValue"]);
    }
}
