// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// The certificate authentication properties for the client.
/// </summary>
public partial class ClientCertificateAuthentication : ProvisionableConstruct
{
    /// <summary>
    /// The validation scheme used to authenticate the client. Default value is
    /// SubjectMatchesAuthenticationName.
    /// </summary>
    public BicepValue<ClientCertificateValidationScheme> ValidationScheme 
    {
        get { Initialize(); return _validationScheme!; }
        set { Initialize(); _validationScheme!.Assign(value); }
    }
    private BicepValue<ClientCertificateValidationScheme>? _validationScheme;

    /// <summary>
    /// The list of thumbprints that are allowed during client authentication.
    /// This property is required only if the validationScheme is
    /// &apos;ThumbprintMatch&apos;.
    /// </summary>
    public BicepList<string> AllowedThumbprints 
    {
        get { Initialize(); return _allowedThumbprints!; }
        set { Initialize(); _allowedThumbprints!.Assign(value); }
    }
    private BicepList<string>? _allowedThumbprints;

    /// <summary>
    /// Creates a new ClientCertificateAuthentication.
    /// </summary>
    public ClientCertificateAuthentication()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ClientCertificateAuthentication.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _validationScheme = DefineProperty<ClientCertificateValidationScheme>("ValidationScheme", ["validationScheme"]);
        _allowedThumbprints = DefineListProperty<string>("AllowedThumbprints", ["allowedThumbprints"]);
    }
}
