// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// BoolEquals Filter.
/// </summary>
public partial class BoolEqualsFilter : EventGridFilter
{
    /// <summary>
    /// The boolean filter value.
    /// </summary>
    public BicepValue<bool> Value 
    {
        get { Initialize(); return _value!; }
        set { Initialize(); _value!.Assign(value); }
    }
    private BicepValue<bool>? _value;

    /// <summary>
    /// Creates a new BoolEqualsFilter.
    /// </summary>
    public BoolEqualsFilter() : base()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of BoolEqualsFilter.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        DefineProperty<string>("operatorType", ["operatorType"], defaultValue: "BoolEquals");
        _value = DefineProperty<bool>("Value", ["value"]);
    }
}
