// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// BoolEquals Advanced Filter.
/// </summary>
public partial class BoolEqualsAdvancedFilter : AdvancedFilter
{
    /// <summary>
    /// The boolean filter value.
    /// </summary>
    public BicepValue<bool> Value 
    {
        get { Initialize(); return _value!; }
        set { Initialize(); _value!.Assign(value); }
    }
    private BicepValue<bool>? _value;

    /// <summary>
    /// Creates a new BoolEqualsAdvancedFilter.
    /// </summary>
    public BoolEqualsAdvancedFilter() : base()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of BoolEqualsAdvancedFilter.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        DefineProperty<string>("operatorType", ["operatorType"], defaultValue: "BoolEquals");
        _value = DefineProperty<bool>("Value", ["value"]);
    }
}
