// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// This is the base type that represents an advanced filter. To configure an
/// advanced filter, do not directly instantiate an object of this class.
/// Instead, instantiate an object of a derived class such as
/// BoolEqualsAdvancedFilter, NumberInAdvancedFilter,
/// StringEqualsAdvancedFilter etc. depending on the type of the key based on
/// which you want to filter.             Please note
/// Azure.ResourceManager.EventGrid.Models.AdvancedFilter is the base class.
/// According to the scenario, a derived class of the base class might need to
/// be assigned here, or this property needs to be casted to one of the
/// possible derived classes.             The available derived classes
/// include Azure.ResourceManager.EventGrid.Models.BoolEqualsAdvancedFilter,
/// Azure.ResourceManager.EventGrid.Models.IsNotNullAdvancedFilter,
/// Azure.ResourceManager.EventGrid.Models.IsNullOrUndefinedAdvancedFilter,
/// Azure.ResourceManager.EventGrid.Models.NumberGreaterThanAdvancedFilter,
/// Azure.ResourceManager.EventGrid.Models.NumberGreaterThanOrEqualsAdvancedFilter,
/// Azure.ResourceManager.EventGrid.Models.NumberInAdvancedFilter,
/// Azure.ResourceManager.EventGrid.Models.NumberInRangeAdvancedFilter,
/// Azure.ResourceManager.EventGrid.Models.NumberLessThanAdvancedFilter,
/// Azure.ResourceManager.EventGrid.Models.NumberLessThanOrEqualsAdvancedFilter,
/// Azure.ResourceManager.EventGrid.Models.NumberNotInAdvancedFilter,
/// Azure.ResourceManager.EventGrid.Models.NumberNotInRangeAdvancedFilter,
/// Azure.ResourceManager.EventGrid.Models.StringBeginsWithAdvancedFilter,
/// Azure.ResourceManager.EventGrid.Models.StringContainsAdvancedFilter,
/// Azure.ResourceManager.EventGrid.Models.StringEndsWithAdvancedFilter,
/// Azure.ResourceManager.EventGrid.Models.StringInAdvancedFilter,
/// Azure.ResourceManager.EventGrid.Models.StringNotBeginsWithAdvancedFilter,
/// Azure.ResourceManager.EventGrid.Models.StringNotContainsAdvancedFilter,
/// Azure.ResourceManager.EventGrid.Models.StringNotEndsWithAdvancedFilter and
/// Azure.ResourceManager.EventGrid.Models.StringNotInAdvancedFilter.
/// </summary>
public partial class AdvancedFilter : ProvisionableConstruct
{
    /// <summary>
    /// The field/property in the event based on which you want to filter.
    /// </summary>
    public BicepValue<string> Key 
    {
        get { Initialize(); return _key!; }
        set { Initialize(); _key!.Assign(value); }
    }
    private BicepValue<string>? _key;

    /// <summary>
    /// Creates a new AdvancedFilter.
    /// </summary>
    public AdvancedFilter()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of AdvancedFilter.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _key = DefineProperty<string>("Key", ["key"]);
    }
}
