// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// EventGridTopic.
/// </summary>
public partial class EventGridTopic : ProvisionableResource
{
    /// <summary>
    /// Name of the topic.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets or sets the Location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Data Residency Boundary of the resource.
    /// </summary>
    public BicepValue<DataResidencyBoundary> DataResidencyBoundary 
    {
        get { Initialize(); return _dataResidencyBoundary!; }
        set { Initialize(); _dataResidencyBoundary!.Assign(value); }
    }
    private BicepValue<DataResidencyBoundary>? _dataResidencyBoundary;

    /// <summary>
    /// Event Type Information for the user topic. This information is provided
    /// by the publisher and can be used by the             subscriber to view
    /// different types of events that are published.
    /// </summary>
    public PartnerTopicEventTypeInfo EventTypeInfo 
    {
        get { Initialize(); return _eventTypeInfo!; }
        set { Initialize(); AssignOrReplace(ref _eventTypeInfo, value); }
    }
    private PartnerTopicEventTypeInfo? _eventTypeInfo;

    /// <summary>
    /// Extended location of the resource.
    /// </summary>
    public ExtendedAzureLocation ExtendedLocation 
    {
        get { Initialize(); return _extendedLocation!; }
        set { Initialize(); AssignOrReplace(ref _extendedLocation, value); }
    }
    private ExtendedAzureLocation? _extendedLocation;

    /// <summary>
    /// Identity information for the resource.
    /// </summary>
    public ManagedServiceIdentity Identity 
    {
        get { Initialize(); return _identity!; }
        set { Initialize(); AssignOrReplace(ref _identity, value); }
    }
    private ManagedServiceIdentity? _identity;

    /// <summary>
    /// This can be used to restrict traffic from specific IPs instead of all
    /// IPs. Note: These are considered only if PublicNetworkAccess is enabled.
    /// </summary>
    public BicepList<EventGridInboundIPRule> InboundIPRules 
    {
        get { Initialize(); return _inboundIPRules!; }
        set { Initialize(); _inboundIPRules!.Assign(value); }
    }
    private BicepList<EventGridInboundIPRule>? _inboundIPRules;

    /// <summary>
    /// This determines the format that Event Grid should expect for incoming
    /// events published to the topic.
    /// </summary>
    public BicepValue<EventGridInputSchema> InputSchema 
    {
        get { Initialize(); return _inputSchema!; }
        set { Initialize(); _inputSchema!.Assign(value); }
    }
    private BicepValue<EventGridInputSchema>? _inputSchema;

    /// <summary>
    /// This enables publishing using custom event schemas. An
    /// InputSchemaMapping can be specified to map various properties of a
    /// source schema to various required properties of the EventGridEvent
    /// schema.             Please note
    /// Azure.ResourceManager.EventGrid.Models.EventGridInputSchemaMapping is
    /// the base class. According to the scenario, a derived class of the base
    /// class might need to be assigned here, or this property needs to be
    /// casted to one of the possible derived classes.             The
    /// available derived classes include
    /// Azure.ResourceManager.EventGrid.Models.EventGridJsonInputSchemaMapping.
    /// </summary>
    public EventGridInputSchemaMapping InputSchemaMapping 
    {
        get { Initialize(); return _inputSchemaMapping!; }
        set { Initialize(); AssignOrReplace(ref _inputSchemaMapping, value); }
    }
    private EventGridInputSchemaMapping? _inputSchemaMapping;

    /// <summary>
    /// This boolean is used to enable or disable local auth. Default value is
    /// false. When the property is set to true, only AAD token will be used
    /// to authenticate if user is allowed to publish to the topic.
    /// </summary>
    public BicepValue<bool> IsLocalAuthDisabled 
    {
        get { Initialize(); return _isLocalAuthDisabled!; }
        set { Initialize(); _isLocalAuthDisabled!.Assign(value); }
    }
    private BicepValue<bool>? _isLocalAuthDisabled;

    /// <summary>
    /// Kind of the resource.
    /// </summary>
    public BicepValue<ResourceKind> Kind 
    {
        get { Initialize(); return _kind!; }
        set { Initialize(); _kind!.Assign(value); }
    }
    private BicepValue<ResourceKind>? _kind;

    /// <summary>
    /// Minimum TLS version of the publisher allowed to publish to this topic.
    /// </summary>
    public BicepValue<TlsVersion> MinimumTlsVersionAllowed 
    {
        get { Initialize(); return _minimumTlsVersionAllowed!; }
        set { Initialize(); _minimumTlsVersionAllowed!.Assign(value); }
    }
    private BicepValue<TlsVersion>? _minimumTlsVersionAllowed;

    /// <summary>
    /// This determines if traffic is allowed over public network. By default
    /// it is enabled.             You can further restrict to specific IPs by
    /// configuring &lt;seealso
    /// cref=&quot;P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.TopicProperties.InboundIpRules&quot;
    /// /&gt;
    /// </summary>
    public BicepValue<EventGridPublicNetworkAccess> PublicNetworkAccess 
    {
        get { Initialize(); return _publicNetworkAccess!; }
        set { Initialize(); _publicNetworkAccess!.Assign(value); }
    }
    private BicepValue<EventGridPublicNetworkAccess>? _publicNetworkAccess;

    /// <summary>
    /// The Sku name of the resource. The possible values are: Basic or Premium.
    /// </summary>
    public BicepValue<EventGridSku> SkuName 
    {
        get { Initialize(); return _skuName!; }
        set { Initialize(); _skuName!.Assign(value); }
    }
    private BicepValue<EventGridSku>? _skuName;

    /// <summary>
    /// Gets or sets the Tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// Endpoint for the topic.
    /// </summary>
    public BicepValue<Uri> Endpoint 
    {
        get { Initialize(); return _endpoint!; }
    }
    private BicepValue<Uri>? _endpoint;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Metric resource id for the topic.
    /// </summary>
    public BicepValue<string> MetricResourceId 
    {
        get { Initialize(); return _metricResourceId!; }
    }
    private BicepValue<string>? _metricResourceId;

    /// <summary>
    /// List of private endpoint connections.
    /// </summary>
    public BicepList<EventGridPrivateEndpointConnectionData> PrivateEndpointConnections 
    {
        get { Initialize(); return _privateEndpointConnections!; }
    }
    private BicepList<EventGridPrivateEndpointConnectionData>? _privateEndpointConnections;

    /// <summary>
    /// Provisioning state of the topic.
    /// </summary>
    public BicepValue<EventGridTopicProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<EventGridTopicProvisioningState>? _provisioningState;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new EventGridTopic.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the EventGridTopic resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the EventGridTopic.</param>
    public EventGridTopic(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.EventGrid/topics", resourceVersion ?? "2022-06-15")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of EventGridTopic.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _dataResidencyBoundary = DefineProperty<DataResidencyBoundary>("DataResidencyBoundary", ["properties", "dataResidencyBoundary"]);
        _eventTypeInfo = DefineModelProperty<PartnerTopicEventTypeInfo>("EventTypeInfo", ["properties", "eventTypeInfo"]);
        _extendedLocation = DefineModelProperty<ExtendedAzureLocation>("ExtendedLocation", ["extendedLocation"]);
        _identity = DefineModelProperty<ManagedServiceIdentity>("Identity", ["identity"]);
        _inboundIPRules = DefineListProperty<EventGridInboundIPRule>("InboundIPRules", ["properties", "inboundIpRules"]);
        _inputSchema = DefineProperty<EventGridInputSchema>("InputSchema", ["properties", "inputSchema"]);
        _inputSchemaMapping = DefineModelProperty<EventGridInputSchemaMapping>("InputSchemaMapping", ["properties", "inputSchemaMapping"]);
        _isLocalAuthDisabled = DefineProperty<bool>("IsLocalAuthDisabled", ["properties", "disableLocalAuth"]);
        _kind = DefineProperty<ResourceKind>("Kind", ["kind"]);
        _minimumTlsVersionAllowed = DefineProperty<TlsVersion>("MinimumTlsVersionAllowed", ["properties", "minimumTlsVersionAllowed"]);
        _publicNetworkAccess = DefineProperty<EventGridPublicNetworkAccess>("PublicNetworkAccess", ["properties", "publicNetworkAccess"]);
        _skuName = DefineProperty<EventGridSku>("SkuName", ["sku", "name"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _endpoint = DefineProperty<Uri>("Endpoint", ["properties", "endpoint"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _metricResourceId = DefineProperty<string>("MetricResourceId", ["properties", "metricResourceId"], isOutput: true);
        _privateEndpointConnections = DefineListProperty<EventGridPrivateEndpointConnectionData>("PrivateEndpointConnections", ["properties", "privateEndpointConnections"], isOutput: true);
        _provisioningState = DefineProperty<EventGridTopicProvisioningState>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }

    /// <summary>
    /// Supported EventGridTopic resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2022-06-15.
        /// </summary>
        public static readonly string V2022_06_15 = "2022-06-15";

        /// <summary>
        /// 2021-12-01.
        /// </summary>
        public static readonly string V2021_12_01 = "2021-12-01";

        /// <summary>
        /// 2020-06-01.
        /// </summary>
        public static readonly string V2020_06_01 = "2020-06-01";

        /// <summary>
        /// 2019-06-01.
        /// </summary>
        public static readonly string V2019_06_01 = "2019-06-01";

        /// <summary>
        /// 2019-01-01.
        /// </summary>
        public static readonly string V2019_01_01 = "2019-01-01";

        /// <summary>
        /// 2018-01-01.
        /// </summary>
        public static readonly string V2018_01_01 = "2018-01-01";
    }

    /// <summary>
    /// Creates a reference to an existing EventGridTopic.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the EventGridTopic resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the EventGridTopic.</param>
    /// <returns>The existing EventGridTopic resource.</returns>
    public static EventGridTopic FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };

    /// <summary>
    /// Get the requirements for naming this EventGridTopic resource.
    /// </summary>
    /// <returns>Naming requirements.</returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override ResourceNameRequirements GetResourceNameRequirements() =>
        new(minLength: 3, maxLength: 50, validCharacters: ResourceNameCharacters.LowercaseLetters | ResourceNameCharacters.UppercaseLetters | ResourceNameCharacters.Numbers | ResourceNameCharacters.Hyphen);
}
