// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// EventGridNamespaceClientResource.
/// </summary>
public partial class EventGridNamespaceClientResource : ProvisionableResource
{
    /// <summary>
    /// The client name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Attributes for the client. Supported values are int, bool, string,
    /// string[].             Example:             &quot;attributes&quot;: {
    /// &quot;room&quot;: &quot;345&quot;, &quot;floor&quot;: 12,
    /// &quot;deviceTypes&quot;: [&quot;Fan&quot;, &quot;Light&quot;] }
    /// To assign an object to the value of this
    /// property use
    /// System.BinaryData.FromObjectAsJson``1(``0,System.Text.Json.JsonSerializerOptions).
    /// To assign an already formatted json string to
    /// this property use System.BinaryData.FromString(System.String).
    /// Examples:
    /// BinaryData.FromObjectAsJson(&quot;foo&quot;)Creates a
    /// payload of
    /// &quot;foo&quot;.BinaryData.FromString(&quot;\&quot;foo\&quot;&quot;)Creates
    /// a payload of &quot;foo&quot;.BinaryData.FromObjectAsJson(new { key =
    /// &quot;value&quot; })Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.BinaryData.FromString(&quot;{\&quot;key\&quot;:
    /// \&quot;value\&quot;}&quot;)Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.
    /// </summary>
    public BicepDictionary<BinaryData> Attributes 
    {
        get { Initialize(); return _attributes!; }
        set { Initialize(); _attributes!.Assign(value); }
    }
    private BicepDictionary<BinaryData>? _attributes;

    /// <summary>
    /// The name presented by the client for authentication. The default value
    /// is the name of the resource.
    /// </summary>
    public BicepValue<string> AuthenticationName 
    {
        get { Initialize(); return _authenticationName!; }
        set { Initialize(); _authenticationName!.Assign(value); }
    }
    private BicepValue<string>? _authenticationName;

    /// <summary>
    /// The client certificate authentication information.
    /// </summary>
    public ClientCertificateAuthentication ClientCertificateAuthentication 
    {
        get { Initialize(); return _clientCertificateAuthentication!; }
        set { Initialize(); AssignOrReplace(ref _clientCertificateAuthentication, value); }
    }
    private ClientCertificateAuthentication? _clientCertificateAuthentication;

    /// <summary>
    /// Description for the Client resource.
    /// </summary>
    public BicepValue<string> Description 
    {
        get { Initialize(); return _description!; }
        set { Initialize(); _description!.Assign(value); }
    }
    private BicepValue<string>? _description;

    /// <summary>
    /// Indicates if the client is enabled or not. Default value is Enabled.
    /// </summary>
    public BicepValue<EventGridNamespaceClientState> State 
    {
        get { Initialize(); return _state!; }
        set { Initialize(); _state!.Assign(value); }
    }
    private BicepValue<EventGridNamespaceClientState>? _state;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Provisioning state of the Client resource.
    /// </summary>
    public BicepValue<EventGridNamespaceClientProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<EventGridNamespaceClientProvisioningState>? _provisioningState;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent EventGridNamespace.
    /// </summary>
    public EventGridNamespace? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<EventGridNamespace>? _parent;

    /// <summary>
    /// Creates a new EventGridNamespaceClientResource.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the EventGridNamespaceClientResource
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the EventGridNamespaceClientResource.</param>
    public EventGridNamespaceClientResource(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.EventGrid/namespaces/clients", resourceVersion)
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// EventGridNamespaceClientResource.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _attributes = DefineDictionaryProperty<BinaryData>("Attributes", ["properties", "attributes"]);
        _authenticationName = DefineProperty<string>("AuthenticationName", ["properties", "authenticationName"]);
        _clientCertificateAuthentication = DefineModelProperty<ClientCertificateAuthentication>("ClientCertificateAuthentication", ["properties", "clientCertificateAuthentication"]);
        _description = DefineProperty<string>("Description", ["properties", "description"]);
        _state = DefineProperty<EventGridNamespaceClientState>("State", ["properties", "state"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _provisioningState = DefineProperty<EventGridNamespaceClientProvisioningState>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<EventGridNamespace>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported EventGridNamespaceClientResource resource versions.
    /// </summary>
    public static class ResourceVersions
    {
    }
    /// <summary>
    /// Creates a reference to an existing EventGridNamespaceClientResource.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the EventGridNamespaceClientResource
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the EventGridNamespaceClientResource.</param>
    /// <returns>The existing EventGridNamespaceClientResource resource.</returns>
    public static EventGridNamespaceClientResource FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
