// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// EventGridNamespace.
/// </summary>
public partial class EventGridNamespace : ProvisionableResource
{
    /// <summary>
    /// Name of the namespace.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets or sets the Location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Identity information for the Namespace resource.
    /// </summary>
    public ManagedServiceIdentity Identity 
    {
        get { Initialize(); return _identity!; }
        set { Initialize(); AssignOrReplace(ref _identity, value); }
    }
    private ManagedServiceIdentity? _identity;

    /// <summary>
    /// This can be used to restrict traffic from specific IPs instead of all
    /// IPs. Note: These are considered only if PublicNetworkAccess is enabled.
    /// </summary>
    public BicepList<EventGridInboundIPRule> InboundIPRules 
    {
        get { Initialize(); return _inboundIPRules!; }
        set { Initialize(); _inboundIPRules!.Assign(value); }
    }
    private BicepList<EventGridInboundIPRule>? _inboundIPRules;

    /// <summary>
    /// This is an optional property and it allows the user to specify if the
    /// namespace resource supports zone-redundancy capability or not. If this
    /// property is not specified explicitly by the user, its
    /// default value depends on the following conditions:                 a.
    /// For Availability Zones enabled regions - The default property value
    /// would be true.                 b. For non-Availability Zones enabled
    /// regions - The default property value would be false.             Once
    /// specified, this property cannot be updated.
    /// </summary>
    public BicepValue<bool> IsZoneRedundant 
    {
        get { Initialize(); return _isZoneRedundant!; }
        set { Initialize(); _isZoneRedundant!.Assign(value); }
    }
    private BicepValue<bool>? _isZoneRedundant;

    /// <summary>
    /// Minimum TLS version of the publisher allowed to publish to this
    /// namespace. Only TLS version 1.2 is supported.
    /// </summary>
    public BicepValue<TlsVersion> MinimumTlsVersionAllowed 
    {
        get { Initialize(); return _minimumTlsVersionAllowed!; }
        set { Initialize(); _minimumTlsVersionAllowed!.Assign(value); }
    }
    private BicepValue<TlsVersion>? _minimumTlsVersionAllowed;

    /// <summary>
    /// List of private endpoint connections.
    /// </summary>
    public BicepList<EventGridPrivateEndpointConnectionData> PrivateEndpointConnections 
    {
        get { Initialize(); return _privateEndpointConnections!; }
        set { Initialize(); _privateEndpointConnections!.Assign(value); }
    }
    private BicepList<EventGridPrivateEndpointConnectionData>? _privateEndpointConnections;

    /// <summary>
    /// This determines if traffic is allowed over public network. By default
    /// it is enabled.             You can further restrict to specific IPs by
    /// configuring &lt;seealso
    /// cref=&quot;P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PubSub.NamespaceProperties.InboundIpRules&quot;
    /// /&gt;
    /// </summary>
    public BicepValue<EventGridPublicNetworkAccess> PublicNetworkAccess 
    {
        get { Initialize(); return _publicNetworkAccess!; }
        set { Initialize(); _publicNetworkAccess!.Assign(value); }
    }
    private BicepValue<EventGridPublicNetworkAccess>? _publicNetworkAccess;

    /// <summary>
    /// Represents available Sku pricing tiers.
    /// </summary>
    public NamespaceSku Sku 
    {
        get { Initialize(); return _sku!; }
        set { Initialize(); AssignOrReplace(ref _sku, value); }
    }
    private NamespaceSku? _sku;

    /// <summary>
    /// Gets or sets the Tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// Topics configuration information for the namespace resource.
    /// </summary>
    public TopicsConfiguration TopicsConfiguration 
    {
        get { Initialize(); return _topicsConfiguration!; }
        set { Initialize(); AssignOrReplace(ref _topicsConfiguration, value); }
    }
    private TopicsConfiguration? _topicsConfiguration;

    /// <summary>
    /// Topic spaces configuration information for the namespace resource.
    /// </summary>
    public TopicSpacesConfiguration TopicSpacesConfiguration 
    {
        get { Initialize(); return _topicSpacesConfiguration!; }
        set { Initialize(); AssignOrReplace(ref _topicSpacesConfiguration, value); }
    }
    private TopicSpacesConfiguration? _topicSpacesConfiguration;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Provisioning state of the namespace resource.
    /// </summary>
    public BicepValue<NamespaceProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<NamespaceProvisioningState>? _provisioningState;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new EventGridNamespace.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the EventGridNamespace resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the EventGridNamespace.</param>
    public EventGridNamespace(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.EventGrid/namespaces", resourceVersion)
    {
    }

    /// <summary>
    /// Define all the provisionable properties of EventGridNamespace.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _identity = DefineModelProperty<ManagedServiceIdentity>("Identity", ["identity"]);
        _inboundIPRules = DefineListProperty<EventGridInboundIPRule>("InboundIPRules", ["properties", "inboundIpRules"]);
        _isZoneRedundant = DefineProperty<bool>("IsZoneRedundant", ["properties", "isZoneRedundant"]);
        _minimumTlsVersionAllowed = DefineProperty<TlsVersion>("MinimumTlsVersionAllowed", ["properties", "minimumTlsVersionAllowed"]);
        _privateEndpointConnections = DefineListProperty<EventGridPrivateEndpointConnectionData>("PrivateEndpointConnections", ["properties", "privateEndpointConnections"]);
        _publicNetworkAccess = DefineProperty<EventGridPublicNetworkAccess>("PublicNetworkAccess", ["properties", "publicNetworkAccess"]);
        _sku = DefineModelProperty<NamespaceSku>("Sku", ["sku"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _topicsConfiguration = DefineModelProperty<TopicsConfiguration>("TopicsConfiguration", ["properties", "topicsConfiguration"]);
        _topicSpacesConfiguration = DefineModelProperty<TopicSpacesConfiguration>("TopicSpacesConfiguration", ["properties", "topicSpacesConfiguration"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _provisioningState = DefineProperty<NamespaceProvisioningState>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }

    /// <summary>
    /// Creates a reference to an existing EventGridNamespace.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the EventGridNamespace resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the EventGridNamespace.</param>
    /// <returns>The existing EventGridNamespace resource.</returns>
    public static EventGridNamespace FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
