// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using System;
using System.ComponentModel;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// Built-in EventGrid roles that you can assign to users, groups, service
/// principals, and managed identities.
/// </summary>
/// <param name="value">The ID value of the role.</param>
public readonly struct EventGridBuiltInRole(string value) : IEquatable<EventGridBuiltInRole>
{
    private readonly string _value = value ?? throw new ArgumentNullException(nameof(value));

    /// <summary>
    /// Lets you manage EventGrid operations.
    /// </summary>
    public static EventGridBuiltInRole EventGridContributor { get; } = new(EventGridContributorValue);
    internal const string EventGridContributorValue = "1e241071-0855-49ea-94dc-649edcd759de";

    /// <summary>
    /// Allows send access to event grid events.
    /// </summary>
    public static EventGridBuiltInRole EventGridDataSender { get; } = new(EventGridDataSenderValue);
    internal const string EventGridDataSenderValue = "d5a91429-5739-47e2-a06b-3470a27159e7";

    /// <summary>
    /// Lets you manage EventGrid event subscription operations.
    /// </summary>
    public static EventGridBuiltInRole EventGridEventSubscriptionContributor { get; } = new(EventGridEventSubscriptionContributorValue);
    internal const string EventGridEventSubscriptionContributorValue = "428e0ff0-5e57-4d9c-a221-2c70d0e0a443";

    /// <summary>
    /// Lets you read EventGrid event subscriptions.
    /// </summary>
    public static EventGridBuiltInRole EventGridEventSubscriptionReader { get; } = new(EventGridEventSubscriptionReaderValue);
    internal const string EventGridEventSubscriptionReaderValue = "2414bbcf-6497-4faf-8c65-045460748405";

    /// <summary>
    /// Try to get the name of a built-in EventGrid role from its ID value.
    /// </summary>
    /// <param name="value">The role value.</param>
    /// <returns>
    /// The name of the built-in EventGrid role if known, otherwise the ID will be returned.
    /// </returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public static string GetBuiltInRoleName(EventGridBuiltInRole value) =>
        value._value switch
        {
            EventGridContributorValue => nameof(EventGridContributor),
            EventGridDataSenderValue => nameof(EventGridDataSender),
            EventGridEventSubscriptionContributorValue => nameof(EventGridEventSubscriptionContributor),
            EventGridEventSubscriptionReaderValue => nameof(EventGridEventSubscriptionReader),
            _ => value._value
        };

    /// <summary>
    /// Determines if two EventGridBuiltInRole values are the same.
    /// </summary>
    /// <param name="left">The first EventGridBuiltInRole to compare.</param>
    /// <param name="right">The second EventGridBuiltInRole to compare.</param>
    /// <returns>True if <paramref name="left"/> and <paramref name="right"/> are the same; otherwise, false.</returns>
    public static bool operator ==(EventGridBuiltInRole left, EventGridBuiltInRole right) => left.Equals(right);

    /// <summary>
    /// Determines if two EventGridBuiltInRole values are different.
    /// </summary>
    /// <param name="left">The first EventGridBuiltInRole to compare.</param>
    /// <param name="right">The second EventGridBuiltInRole to compare.</param>
    /// <returns>True if <paramref name="left"/> and <paramref name="right"/> are different; otherwise, false.</returns>
    public static bool operator !=(EventGridBuiltInRole left, EventGridBuiltInRole right) => !left.Equals(right);

    /// <summary>
    /// Converts a string to a EventGridBuiltInRole.
    /// </summary>
    /// <param name="value">The string value to convert.</param>
    public static implicit operator EventGridBuiltInRole(string value) => new(value);

    /// <inheritdoc/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override bool Equals(object? obj) => obj is EventGridBuiltInRole other && Equals(other);

    /// <inheritdoc/>
    public bool Equals(EventGridBuiltInRole other) => string.Equals(_value, other._value, StringComparison.Ordinal);

    /// <inheritdoc/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override int GetHashCode() => _value?.GetHashCode() ?? 0;

    /// <inheritdoc/>
    public override string ToString() => _value;
}
