// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.EventGrid;

/// <summary>
/// CaCertificate.
/// </summary>
public partial class CaCertificate : ProvisionableResource
{
    /// <summary>
    /// The CA certificate name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Description for the CA Certificate resource.
    /// </summary>
    public BicepValue<string> Description 
    {
        get { Initialize(); return _description!; }
        set { Initialize(); _description!.Assign(value); }
    }
    private BicepValue<string>? _description;

    /// <summary>
    /// Base64 encoded PEM (Privacy Enhanced Mail) format certificate data.
    /// </summary>
    public BicepValue<string> EncodedCertificate 
    {
        get { Initialize(); return _encodedCertificate!; }
        set { Initialize(); _encodedCertificate!.Assign(value); }
    }
    private BicepValue<string>? _encodedCertificate;

    /// <summary>
    /// Certificate expiry time in UTC. This is a read-only field.
    /// </summary>
    public BicepValue<DateTimeOffset> ExpiryTimeInUtc 
    {
        get { Initialize(); return _expiryTimeInUtc!; }
    }
    private BicepValue<DateTimeOffset>? _expiryTimeInUtc;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Certificate issue time in UTC. This is a read-only field.
    /// </summary>
    public BicepValue<DateTimeOffset> IssueTimeInUtc 
    {
        get { Initialize(); return _issueTimeInUtc!; }
    }
    private BicepValue<DateTimeOffset>? _issueTimeInUtc;

    /// <summary>
    /// Provisioning state of the CA Certificate resource.
    /// </summary>
    public BicepValue<CaCertificateProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<CaCertificateProvisioningState>? _provisioningState;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent EventGridNamespace.
    /// </summary>
    public EventGridNamespace? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<EventGridNamespace>? _parent;

    /// <summary>
    /// Creates a new CaCertificate.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the CaCertificate resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the CaCertificate.</param>
    public CaCertificate(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.EventGrid/namespaces/caCertificates", resourceVersion)
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CaCertificate.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _description = DefineProperty<string>("Description", ["properties", "description"]);
        _encodedCertificate = DefineProperty<string>("EncodedCertificate", ["properties", "encodedCertificate"]);
        _expiryTimeInUtc = DefineProperty<DateTimeOffset>("ExpiryTimeInUtc", ["properties", "expiryTimeInUtc"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _issueTimeInUtc = DefineProperty<DateTimeOffset>("IssueTimeInUtc", ["properties", "issueTimeInUtc"], isOutput: true);
        _provisioningState = DefineProperty<CaCertificateProvisioningState>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<EventGridNamespace>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported CaCertificate resource versions.
    /// </summary>
    public static class ResourceVersions
    {
    }
    /// <summary>
    /// Creates a reference to an existing CaCertificate.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the CaCertificate resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the CaCertificate.</param>
    /// <returns>The existing CaCertificate resource.</returns>
    public static CaCertificate FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
