// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Cosmos DB resource throughput object. Either throughput is required or
/// autoscaleSettings is required, but not both.
/// </summary>
public partial class ThroughputSettingsResourceInfo : ProvisionableConstruct
{
    /// <summary>
    /// Value of the Cosmos DB resource throughput. Either throughput is
    /// required or autoscaleSettings is required, but not both.
    /// </summary>
    public BicepValue<int> Throughput 
    {
        get { Initialize(); return _throughput!; }
        set { Initialize(); _throughput!.Assign(value); }
    }
    private BicepValue<int>? _throughput;

    /// <summary>
    /// Cosmos DB resource for autoscale settings. Either throughput is
    /// required or autoscaleSettings is required, but not both.
    /// </summary>
    public AutoscaleSettingsResourceInfo AutoscaleSettings 
    {
        get { Initialize(); return _autoscaleSettings!; }
        set { Initialize(); AssignOrReplace(ref _autoscaleSettings, value); }
    }
    private AutoscaleSettingsResourceInfo? _autoscaleSettings;

    /// <summary>
    /// The minimum throughput of the resource.
    /// </summary>
    public BicepValue<string> MinimumThroughput 
    {
        get { Initialize(); return _minimumThroughput!; }
    }
    private BicepValue<string>? _minimumThroughput;

    /// <summary>
    /// The throughput replace is pending.
    /// </summary>
    public BicepValue<string> OfferReplacePending 
    {
        get { Initialize(); return _offerReplacePending!; }
    }
    private BicepValue<string>? _offerReplacePending;

    /// <summary>
    /// The offer throughput value to instantly scale up without triggering
    /// splits.
    /// </summary>
    public BicepValue<string> InstantMaximumThroughput 
    {
        get { Initialize(); return _instantMaximumThroughput!; }
    }
    private BicepValue<string>? _instantMaximumThroughput;

    /// <summary>
    /// The maximum throughput value or the maximum maxThroughput value (for
    /// autoscale) that can be specified.
    /// </summary>
    public BicepValue<string> SoftAllowedMaximumThroughput 
    {
        get { Initialize(); return _softAllowedMaximumThroughput!; }
    }
    private BicepValue<string>? _softAllowedMaximumThroughput;

    /// <summary>
    /// Creates a new ThroughputSettingsResourceInfo.
    /// </summary>
    public ThroughputSettingsResourceInfo()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ThroughputSettingsResourceInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _throughput = DefineProperty<int>("Throughput", ["throughput"]);
        _autoscaleSettings = DefineModelProperty<AutoscaleSettingsResourceInfo>("AutoscaleSettings", ["autoscaleSettings"]);
        _minimumThroughput = DefineProperty<string>("MinimumThroughput", ["minimumThroughput"], isOutput: true);
        _offerReplacePending = DefineProperty<string>("OfferReplacePending", ["offerReplacePending"], isOutput: true);
        _instantMaximumThroughput = DefineProperty<string>("InstantMaximumThroughput", ["instantMaximumThroughput"], isOutput: true);
        _softAllowedMaximumThroughput = DefineProperty<string>("SoftAllowedMaximumThroughput", ["softAllowedMaximumThroughput"], isOutput: true);
    }
}
