// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Cosmos DB resource throughput policy.
/// </summary>
public partial class ThroughputPolicyResourceInfo : ProvisionableConstruct
{
    /// <summary>
    /// Determines whether the ThroughputPolicy is active or not.
    /// </summary>
    public BicepValue<bool> IsEnabled 
    {
        get { Initialize(); return _isEnabled!; }
        set { Initialize(); _isEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isEnabled;

    /// <summary>
    /// Represents the percentage by which throughput can increase every time
    /// throughput policy kicks in.
    /// </summary>
    public BicepValue<int> IncrementPercent 
    {
        get { Initialize(); return _incrementPercent!; }
        set { Initialize(); _incrementPercent!.Assign(value); }
    }
    private BicepValue<int>? _incrementPercent;

    /// <summary>
    /// Creates a new ThroughputPolicyResourceInfo.
    /// </summary>
    public ThroughputPolicyResourceInfo()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ThroughputPolicyResourceInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _isEnabled = DefineProperty<bool>("IsEnabled", ["isEnabled"]);
        _incrementPercent = DefineProperty<int>("IncrementPercent", ["incrementPercent"]);
    }
}
