// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Properties for SqlDedicatedGatewayServiceResource.
/// </summary>
public partial class SqlDedicatedGatewayServiceProperties : CosmosDBServiceProperties
{
    /// <summary>
    /// SqlDedicatedGateway endpoint for the service.
    /// </summary>
    public BicepValue<string> SqlDedicatedGatewayEndpoint 
    {
        get { Initialize(); return _sqlDedicatedGatewayEndpoint!; }
        set { Initialize(); _sqlDedicatedGatewayEndpoint!.Assign(value); }
    }
    private BicepValue<string>? _sqlDedicatedGatewayEndpoint;

    /// <summary>
    /// An array that contains all of the locations for the service.
    /// </summary>
    public BicepList<SqlDedicatedGatewayRegionalService> Locations 
    {
        get { Initialize(); return _locations!; }
    }
    private BicepList<SqlDedicatedGatewayRegionalService>? _locations;

    /// <summary>
    /// Creates a new SqlDedicatedGatewayServiceProperties.
    /// </summary>
    public SqlDedicatedGatewayServiceProperties() : base()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// SqlDedicatedGatewayServiceProperties.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        DefineProperty<string>("serviceType", ["serviceType"], defaultValue: "SqlDedicatedGateway");
        _sqlDedicatedGatewayEndpoint = DefineProperty<string>("SqlDedicatedGatewayEndpoint", ["sqlDedicatedGatewayEndpoint"]);
        _locations = DefineListProperty<SqlDedicatedGatewayRegionalService>("Locations", ["locations"], isOutput: true);
    }
}
