// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Resource for a regional service location.
/// </summary>
public partial class SqlDedicatedGatewayRegionalService : ProvisionableConstruct
{
    /// <summary>
    /// The regional endpoint for SqlDedicatedGateway.
    /// </summary>
    public BicepValue<string> SqlDedicatedGatewayEndpoint 
    {
        get { Initialize(); return _sqlDedicatedGatewayEndpoint!; }
    }
    private BicepValue<string>? _sqlDedicatedGatewayEndpoint;

    /// <summary>
    /// The regional service name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The location name.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Describes the status of a service.
    /// </summary>
    public BicepValue<CosmosDBServiceStatus> Status 
    {
        get { Initialize(); return _status!; }
    }
    private BicepValue<CosmosDBServiceStatus>? _status;

    /// <summary>
    /// Creates a new SqlDedicatedGatewayRegionalService.
    /// </summary>
    public SqlDedicatedGatewayRegionalService()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// SqlDedicatedGatewayRegionalService.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _sqlDedicatedGatewayEndpoint = DefineProperty<string>("SqlDedicatedGatewayEndpoint", ["sqlDedicatedGatewayEndpoint"], isOutput: true);
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isOutput: true);
        _status = DefineProperty<CosmosDBServiceStatus>("Status", ["status"], isOutput: true);
    }
}
